"use strict";
this.name = "Smugglers_PhaseScanner";
this.author = "phkb";
this.description = "Looks after the new phase scanning equipment activation.";
this.licence = "CC BY-NC-SA 3.0";

this._scanCount = 0; // percentage of scan completed
this._speedCount = 0; // counter for when player ship speed drops below 100 m/s.
this._scanTimer = null; // timer to perform scan
this._energy = null; // timer to deduct energy
this._energyReduction = 4; // amount of energy to deduct each quarter second

//-------------------------------------------------------------------------------------------------------------
this.activated = function () {

	var core = worldScripts.Smugglers_CoreFunctions;
	this.$rand = core.$rand;

	var se = worldScripts.Smugglers_Equipment;

	if (this._scanTimer && this._scanTimer.isRunning) {
		this._scanTimer.stop();
		this._energy.stop();
		player.consoleMessage(expandMissionText("smuggling_scanner_stopped"));
		se.$playSound("stop");
		return;
	}

	var p = player.ship;

	// is the equipment OK?
	if (p.equipmentStatus("EQ_PHASE_SCANNER") != "EQUIPMENT_OK") {
		se.$playSound("stop");
		return;
	}

	// do we have a station target and is it a main station?
	if (p.target != system.mainStation) {
		player.consoleMessage(expandMissionText("smuggling_invalid_target"));
		se.$playSound("stop");
		return;
	}
	if (p.isCloaked) {
		player.consoleMessage(expandMissionText("smuggling_cloaked"));
		se.$playSound("stop");
		return;
	}

	player.consoleMessage(expandMissionText("smuggling_scanner_started"));

	this._scanCount = 0;
	this._speedCount = 0;
	if (this._scanTimer && this._scanTimer.isRunning) this._scanTimer.stop();
	this._scanTimer = new Timer(this, this.$scanProcess, 3, 3);
	if (this._energy && this._energy.isRunning) this._energy.stop();
	this._energy = new Timer(this, this.$depleteEnergy, 0.25, 0.25);

	se.$playSound("activate");

}

//-------------------------------------------------------------------------------------------------------------
// find all police or main stations within 15500km of of ship
this.$findLawVessels = function $findLawVessels(npc) {
	function _ships(entity) {
		return entity.isShip && entity.isPolice && !entity.isPlayer && !entity.isStation && !entity.isMainStation;
	}
	return system.filteredEntities(this, _ships, npc, npc.scannerRange * 0.6);
}

//-------------------------------------------------------------------------------------------------------------
this.$scanProcess = function $scanProcess() {

	var p = player.ship;

	// do we have a station target and is it a main station?
	if (p.target != system.mainStation) {
		player.consoleMessage(expandMissionText("smuggling_invalid_target"));
		this._scanTimer.stop();
		this._energy.stop();
		return;
	}

	if (p.isCloaked) {
		player.consoleMessage(expandMissionText("smuggling_cloaked"));
		this._scanTimer.stop();
		this._energy.stop();
		return;
	}

	var se = worldScripts.Smugglers_Equipment;

	// how far away are we?
	var penalty = 0;
	var msg = "";
	var dist = p.position.distanceTo(p.target);
	if (dist < (p.scannerRange * 0.78625) && se._phaseScannerDetected === false) {
		// too close
		msg = expandDescription("[illegal-scan-detected-station]");
		p.target.commsMessage(msg, p);
		penalty = this.$rand(20) + 10;
		p.setBounty(player.bounty + penalty, "seen by police");
		this.$sendEmail(penalty);
		se._phaseScannerDetected = true;
	}
	// is there any police vessel in range?
	var police = this.$findLawVessels(p);
	if (police.length > 0 && se._phaseScannerDetected === false) {
		msg = expandDescription("[illegal-scan-detected-police]");
		penalty = this.$rand(20) + 10;
		p.setBounty(player.bounty + penalty, "seen by police");
		this.$sendEmail(penalty);
		police[0].commsMessage(msg, p);
		se._phaseScannerDetected = true;
	}
	// are we too far away for a good scan?
	if (dist > (p.scannerRange * 0.90242)) {
		return;
	}

	if (p.speed < 100 && this._speedCount > 20) {
		// too slow for too long
		msg = expandDescription("[illegal-scan-detected-station]");
		p.target.commsMessage(msg, p);
		penalty = this.$rand(20) + 10;
		p.setBounty(player.bounty + penalty, "seen by police");
		this.$sendEmail(penalty);
		se._phaseScannerDetected = true;
	}

	// ok, we're close enough, so increase the percentage
	this._scanCount += 1;
	player.consoleMessage(expandMissionText("smuggling_scan", { amount: (this._scanCount * 10) }), 3);
	if (this._scanCount >= 10) {
		var phase = se.$getSystemPhase(system.ID);
		player.consoleMessage(expandMissionText("smuggling_scan_result", { phase: phase }), 6);
		// add it to our discovered list
		se.$addPhaseScan(phase, system.ID, 1);
		// stop the timer and reset the count
		this._scanTimer.stop();
		this._energy.stop();
		this._scanCount = 0;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$depleteEnergy = function $depleteEnergy() {
	var p = player.ship;
	p.energy -= this._energyReduction;
	if (p.energy < 64) {
		this._scanTimer.stop();
		this._energy.stop();
		player.consoleMessage(expandMissionText("smuggling_insufficient_energy"));
	}
	if (p.speed < 100) {
		this._speedCount += 1;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$sendEmail = function $sendEmail(penalty) {
	var email = worldScripts.EmailSystem;
	if (email) {
		var ga = worldScripts.GalCopAdminServices;
		if (ga._galCopBountyOfficer === "") ga._galCopBountyOfficer = expandDescription("%N [nom]");

		email.$createEmail({
			sender: expandDescription("[galcop-bounty-sender]"),
			subject: expandMissionText("smuggling_bounty"),
			date: clock.seconds,
			message: expandMissionText("galcop-bounty-applied", {
				amount: penalty,
				systemname: system.info.name,
				sender: ga._galCopBountyOfficer
			}),
			expiryDays: ga._defaultExpiryDays
		});
	}
}