"use strict";
this.name = "Smugglers_MoveCargo";
this.author = "phkb";
this.description = "Looks after the process of moving cargo into the smuggling compartment during flight.";
this.licence = "CC BY-NC-SA 3.0";

this._scoopedCargo = [];
this._commodityUnits = {};
this._cycleIndex = -1;
this._selected = null;

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
    var m = system.mainStation.market;
    if (m) {
        var list = Object.keys(m);
        for (var i = 0; i < list.length; i++) {
            var c = m[list[i]];
            this._commodityUnits[c.key] = (c.quantity_unit === "0" ? "t" : (c.quantity_unit === "1" ? "kg" : "g"));
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipDockedAtStation = function (station) {
    this._scoopedCargo.length = 0;
}

//-------------------------------------------------------------------------------------------------------------
this.mode = function () {
    // cycle through available, non-labelled cargo, including scooped items (but not escape pods)
    // group precious items: existing cargo at launch as amounts (eg 15g gemstones), scooped cargo amounts (eg 9kg gold)
    var p = player.ship;
    var list = [];
    var cargo = p.manifest.list;
    var sdm = worldScripts.Smugglers_DockMaster;
    var sde = worldScripts.Smugglers_Equipment;
    var sdmc = worldScripts.Smugglers_MoveCargo;
    var itemcount = 0;

    // add the scooped items first
    for (var i = 0; i < sdmc._scoopedCargo.length; i++) {
        var item = sdmc._scoopedCargo[i];
        if (item.isValid && item.status === "STATUS_IN_HOLD") {
            list.push({
                text: expandMissionText("smuggling_move_cargo", { commodity: item.commodityAmount + sdmc._commodityUnits[item.commodity] + " × " + displayNameForCommodity(item.commodity) }) + " " + expandMissionText("smuggling_scooped"),
                scoopedItem: item,
                commodity: item.commodity,
                quantity: item.commodityAmount,
                unit: sdmc._commodityUnits[item.commodity]
            });
        }
    }

    // then the items in the hold.
    var existing = [];
    for (var i = 0; i < cargo.length; i++) {
        // only show standard (non-OXP) commodity items
        if (sde._commodityIDList.indexOf(cargo[i].commodity) >= 0) {
            var q = cargo[i].quantity - sdmc.$scoopedCargoAmount(cargo[i].commodity);
            // don't allow scooped escape pods to be moved
            if (cargo[i].commodity === "slaves" && q > 0 && worldScripts.EscapePodTweaks && worldScripts.EscapePodTweaks._escapePods.length > 0) {
                q -= worldScripts.EscapePodTweaks._escapePods;
            }
            // todo: how to handle scooped escape pods when escape pod tweaks isn't installed

            // make sure we don't move relabelled cargo
            if (sdm._cargoLabelled.length > 0) {
                for (var j = 0; j < sdm._cargoLabelled.length; j++) {
                    if (sdm._cargoLabelled[j].newCommodity === cargo[i].commodity) q -= sdm._cargoLabelled[j].quantity;
                }
            }
            if (q > 0) {
                switch (cargo[i].unit) {
                    case "t":
                        if (existing.indexOf(cargo[i].commodity) === -1) {
                            list.push({
                                text: expandMissionText("smuggling_move_cargo", { commodity: "1" + cargo[i].unit + " × " + cargo[i].displayName }),
                                scoopedItem: null,
                                commodity: cargo[i].commodity,
                                quantity: 1,
                                unit: cargo[i].unit
                            });
                            existing.push(cargo[i].commodity);
                        }
                        break;
                    case "kg":
                        var step = 1000;
                        if (step > q) step = q;
                        var checktot = q;
                        for (var k = 1; k <= q; k += step) {
                            checktot -= step;
                            if (checktot < 0) {
                                list.push({
                                    text: expandMissionText("smuggling_move_cargo", { commodity: (step + checktot).toString() + cargo[i].unit + " × " + cargo[i].displayName }),
                                    scoopedItem: null,
                                    commodity: cargo[i].commodity,
                                    quantity: (step + checktot),
                                    unit: cargo[i].unit
                                });
                            } else {
                                if (existing.indexOf(cargo[i].commodity) === -1) {
                                    list.push({
                                        text: expandMissionText("smuggling_move_cargo", { commodity: step.toString() + cargo[i].unit + " × " + cargo[i].displayName }),
                                        scoopedItem: null,
                                        commodity: cargo[i].commodity,
                                        quantity: step,
                                        unit: cargo[i].unit
                                    });
                                    existing.push(cargo[i].commodity);
                                }
                            }
                        }
                        break;
                    case "g":
                        var step = 1000000;
                        if (step > q) step = q;
                        var checktot = q;
                        for (var k = 1; k <= q; k += step) {
                            checktot -= step;
                            if (checktot < 0) {
                                list.push({
                                    text: expandMissionText("smuggling_move_cargo", {commodity:(step + checktot).toString() + cargo[i].unit + " × " + cargo[i].displayName}),
                                    scoopedItem: null,
                                    commodity: cargo[i].commodity,
                                    quantity: (step + checktot),
                                    unit: cargo[i].unit
                                });
                            } else {
                                if (existing.indexOf(cargo[i].commodity) === -1) {
                                    list.push({
                                        text: expandMissionText("smuggling_move_cargo", {commodity:step.toString() + cargo[i].unit + " × " + cargo[i].displayName}),
                                        scoopedItem: null,
                                        commodity: cargo[i].commodity,
                                        quantity: step,
                                        unit: cargo[i].unit
                                    });
                                    existing.push(cargo[i].commodity);
                                }
                            }
                        }
                        break;
                }
            }
        }
    }

    if (list.length === 0) return;

    sdmc._cycleIndex += 1;
    if (sdmc._cycleIndex >= list.length) sdmc._cycleIndex = 0;
    sdmc._selected = list[sdmc._cycleIndex];
    player.consoleMessage(list[sdmc._cycleIndex].text);
}

//-------------------------------------------------------------------------------------------------------------
this.activated = function () {
    // move the selected item 
    var sde = worldScripts.Smugglers_Equipment;
    var sdmc = worldScripts.Smugglers_MoveCargo;
    if (sdmc._selected != null) {
        var item = sdmc._selected;
        // any space left for transfer?
        var checkAmount = item.quantity;
        if (item.unit === "kg") checkAmount /= 1000;
        if (item.unit === "g") checkAmount /= 1000000;
        if (sde.$availableSpace() < checkAmount) {
            player.consoleMessage(expandMissionText("smuggling_compartment_full"));
            return;
        }
        sde.$addCargoToCompartment(item.commodity, displayNameForCommodity(item.commodity), item.quantity, item.unit);
        if (item.scoopedItem != null) {
            for (var i = 0; i < sdmc._scoopedCargo.length; i++) {
                if (sdmc._scoopedCargo[i] == item.scoopedItem) {
                    sdmc._scoopedCargo.splice(i, 1);
                    break;
                }
            }
            item.scoopedItem.remove(true);
        }
        var p = player.ship;
        if (sde._NCInstalled == true) {
            var tfr = item.quantity;
            var storage = [];
            var ncmanifest = cte.suspendPlayerManifest(item.commodity);
            var nc = ncmanifest.split("|");
            var lst = nc[1].split("/");
            for (var i = 0; i < lst.length; i++) {
                // reduce the original
                var sub = lst[i].split("=");
                sub[1]--;
                lst[i] = sub.join("=");

                // make a copy of what we're taking out
                // we'll store this as i unit entries, rather than trying to sum them up here,
                // to make it easier at the other end when we're taking stuff out
                var st = "";
                for (var j = 0; j < sub.length; j++) {
                    st += (st == "" ? "" : "=") + (j == 1 ? 1 : sub[j]);
                }
                storage.push(st);
                tfr--;
                if (tfr == 0) break;
            }
            nc[1] = lst.join("/");
            ncmanifest = nc.join("|");

            // tell NC about what we've done
            cte.mergePlayerManifest(ncmanifest);
            // pull our storage data together
            extra = storage.join("/");
        }

        // the manifest of any "kg" or "g" type commodities can't be reduced (in-flight only)
        // so add 1 to the value so Oolite with consider the commodity as being out of the hold
        var bugfix = false;
        if (item.unit === "kg" || item.unit === "g") {
            p.manifest[item.commodity] += 1;
            bugfix = true;
        }
        // if we added one, make sure we add it so we can take it away again.
        p.manifest[item.commodity] -= (item.quantity + (bugfix === true ? 1 : 0));
        player.consoleMessage(item.quantity + item.unit + " × " + displayNameForCommodity(item.commodity) + " " + expandMissionText("smuggling_transferred"));
        sdmc._selected = null;
        sdmc._cycleIndex = -1;
        // force an update of the manifest MFD, as it won't detect changes in kg or g type commodities
        if (item.unit != "t" && worldScripts["manifest_mfd"] && p.equipmentStatus("EQ_MANIFEST_MFD") === "EQUIPMENT_OK") {
            worldScripts["manifest_mfd"].$updateManifestMFD();
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipScoopedOther = function (cargo) {
    // we don't move escape pods (which will have a crew)
    if (cargo.isValid === false) return;
    if (cargo.commodity != "slaves" || (!cargo.crew || cargo.crew.length === 0)) {
        if (cargo.script.shipWasDumped) cargo.script.$sdmovr_shipWasDumped = cargo.script.shipWasDumped;
        cargo.script.shipWasDumped = this.$sdm_shipWasDumped;
        this._scoopedCargo.push(cargo);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$sdm_shipWasDumped = function $sdm_shipWasDumped(dumper) {
    if (this.ship.script.$sdmovr_shipWasDumped) this.ship.script.$sdmovr_shipWasDumped(dumper);
    if (dumper.isPlayer) {
        var sdmc = worldScripts.Smugglers_MoveCargo;
        for (var i = 0; i < sdmc._scoopedCargo.length; i++) {
            if (sdmc._scoopedCargo[i] == this.ship) {
                sdmc._scoopedCargo.splice(i, 1);
                break;
            }
        }
    }
    // detach our custom script
    delete this.ship.script.shipWasDumped;
    if (this.ship.script.$sdmovr_shipWasDumped) {
        this.ship.script.shipWasDumped = this.ship.script.$sdmovr_shipWasDumped;
        delete this.ship.script.$sdmovr_shipWasDumped;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$scoopedCargoAmount = function $scoopedCargoAmount(cmdty) {
    var sdmc = worldScripts.Smugglers_MoveCargo;
    if (sdmc._scoopedCargo.length === 0) return 0;
    var amt = 0;
    var sc = sdmc._scoopedCargo;
    for (var i = 0; i < sc.length; i++) {
        if (sc[i].commodity === cmdty) amt += sc[i].commodityAmount;
    }
    return amt;
}