"use strict";
/*

tianve-rebecca-script.js

Ship script for Rebecca Weston.

Oolite - Copyright © 2009 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.


Tianve.oxp - Copyright © 2009 Drew Wagar

This work is licensed under the Creative Commons
Attribution-Noncommercial-Share Alike 3.0 Unported License.

To view a copy of this license, visit
http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter
to Creative Commons, 171 Second Street, Suite 300, San Francisco,
California, 94105, USA.

*/

this.name = "tianve-rebecca-script";
this.author = "Commander McLane";
this.copyright = "© 2009 Drew Wagar";
this.license = "CC-by-nc-sa 3.0";


this.shipSpawned = function () {
	// sets primary role to "hunter", to make it accept distress calls
	this.ship.primaryRole = "hunter";
	/*	
		// establishes the station group of the monitoring station
		var pulsarStationGroup = system.shipsWithRole("tianve-pulsar-station", this.ship)[0].group;
	
		// adds Rebecca to the station group
		pulsarStationGroup.addShip(this.ship);
	
		// and makes her aware of that
		this.ship.group = pulsarStationGroup;
	*/
	// starts a timer that periodically looks for the player
	// the timer looks every ten seconds (second number)
	this.scanForPlayerTimer = new Timer(this, this.scanForPlayer, 0, 10);
}

this.scanForPlayer = function () {
	//  when having the player in scanner range for the first time ...
	if (this.ship.position.distanceTo(player.ship.position) < 25600) {
		this.$updatePAD();
		// ... a message is sent ...
		this.ship.commsMessage(expandMissionText("tianve_rebecca_welcome"));
		// ... and the timer is stopped
		this.scanForPlayerTimer.stop();
	}
}

this.playerWillEnterWitchspace = this.shipDied = function () {
	// if the ship suffers an existence failure, either by dying or by the player leaving the system,
	// the timer is stopped and removed
	this.scanForPlayerTimer.stop();
	delete this.scanForPlayerTimer;
}

this.rebeccaAIPoint1 = function() {
	//-518000 137500 979000
	var pws = worldScripts["oolite-tianve"];
	this.ship.destination = Vector3D(pws._pulsarStnPWM[0] + 10000, pws._pulsarStnPWM[1], pws._pulsarStnPWM[2]).fromCoordinateSystem("pwm");
}
this.rebeccaAIPoint2 = function() {
	//-538000 137500 979000
	var pws = worldScripts["oolite-tianve"];
	this.ship.destination = Vector3D(pws._pulsarStnPWM[0] - 10000, pws._pulsarStnPWM[1], pws._pulsarStnPWM[2]).fromCoordinateSystem("pwm");
}
this.rebeccaAIPoint3 = function() {
	//-528000 147500 979000
	var pws = worldScripts["oolite-tianve"];
	this.ship.destination = Vector3D(pws._pulsarStnPWM[0], pws._pulsarStnPWM[1] + 10000, pws._pulsarStnPWM[2]).fromCoordinateSystem("pwm");
}
this.rebeccaAIPoint4 = function() {
	//-528000 127500 979000
	var pws = worldScripts["oolite-tianve"];
	this.ship.destination = Vector3D(pws._pulsarStnPWM[0], pws._pulsarStnPWM[1] - 10000, pws._pulsarStnPWM[2]).fromCoordinateSystem("pwm");
}
this.rebeccaAIPoint5 = function() {
	//-528000 137500 989000
	var pws = worldScripts["oolite-tianve"];
	this.ship.destination = Vector3D(pws._pulsarStnPWM[0], pws._pulsarStnPWM[1], pws._pulsarStnPWM[2] + 10000).fromCoordinateSystem("pwm");
}
this.rebeccaAIPoint6 = function() {
	//-528000 137500 969000
	var pws = worldScripts["oolite-tianve"];
	this.ship.destination = Vector3D(pws._pulsarStnPWM[0], pws._pulsarStnPWM[1], pws._pulsarStnPWM[2] - 10000).fromCoordinateSystem("pwm");
}

//-------------------------------------------------------------------------------------------------------------
this.$updatePAD = function () {
    // add our dead officer to PAD
    var pad = worldScripts.Lib_PAD;
    pad._addPageInCategory(
        "PERSONS.REBECCA WESTON",
        {
            name: expandMissionText("tianve_rebecca_name"),
            origin: "Tianve",
            species: expandMissionText("LIB_PAD_SPECIES_HUMAN"),
            gender: expandMissionText("LIB_PAD_GENDER_FEMALE"),
            age: 26,
            ship: expandMissionText("tianve_rebecca_ship"),
            rank: "",
            t0: 0,
            t1: "rebecca_weston.png",
            t2: 0,
            info: []
        },
        ["PERSONS.GENERIC"],
        false
    );

	var infoLines = expandDescription("[rebecca_weston_info]").split("\n");
	var i = infoLines.length;
	while (i--) {
		worldScripts.Lib_PAD._setPageEntry("PERSONS.REBECCA WESTON.info", infoLines[i]);
	}
}
