"use strict";
this.name = "oolite-tianve";
this.author = "Drew Wagar and Contributions by Commander McLane and phkb";
this.copyright = "© 2009 Drew Wagar.";
this.description = "Makeover for the Tianve Star System in Chart One";
this.license = "CC-by-nc-sa 3.0";

this._pulsarPosPWM = [-537000, 138000, 1011250];
this._pulsarStnPWM = [];

// todo
// 3. rotate the pulsar?
// 4. add ships to shiplibrary.plist
// 5. new cargoes specialties

this._posVE;
this._posStn;
this._massLocker = null;
this._always = false; // used for debugging only

// OXP link note:
// To relocate the pulsar, change the "this._pulsarPosPWM" values during startUp function
//-------------------------------------------------------------------------------------------------------------
this.startUp = function() {
	if (worldScripts["Famous Planets Overhaul"]) {
		// we want to keep our texture for the planet
		var fpo = worldScripts["Famous Planets Overhaul"];
		var idx = fpo.planetList[0].indexOf(246);
		fpo.planetList.splice(idx, 1);
	}

	var pf = worldScripts.PlanetFall2;
	if (!pf) return;
    pf._locationOverrides["0 246"] = {
        main: [
            {
                roles: ["capitalCity", "capitalCity", "capitalCity", "leisureComplex", "leisureComplex", "factory"],
                names: ["Tianvilus (Capital City)", "Wagarville (City)", "Drewston (City)",  "Pillars of Tiaxus (Xootian Desert)", "Mount Aliothn (Leisure Complex)", "Acid Lake City (Factory)"],
            },
        ],
    };
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	var vx = worldScripts.VimanaX_HUD;
	if (vx) {
		// update vimana to use a different model to the original
		vx._gameShips["Tianve Pulsar Monitoring Station"] = "octahedron";
		vx._gameShips["The Pulsar Monitoring Station"] = "octahedron";
		vx._gameShips["Vampire Mk1.5 : Rebecca Weston"] = "vampiremk1";
		vx._gameShips["Tianve Billboard"] = "billboard";
		vx._gameShips["Tourist StarLiner - 'Join us next time, Commander!'"] = "boa_cruiser";
		vx._gameShips["Tourist StarLiner - 'Seats Available, Commander!'"] = "boa_cruiser";
	}

    // make sure our texture wins any races to be the last texture installed
    var info = System.infoForSystem(0, 246);
    info.texture = "tianve_planet.png";
}


//-------------------------------------------------------------------------------------------------------------
this.turnStationToEntity = function (station, entity) {
	var targetVector = entity.position.subtract(station.position).direction();
	station.orientation = targetVector.rotationTo([0, 0, 1]);
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function () {
	this._posVE = null;
	this._posStn = null;

	if (galaxyNumber === 0 && system.ID === 246 || this._always == true) {
		this._pulsarStnPWM.push(this._pulsarPosPWM[0] + 9000);
		this._pulsarStnPWM.push(this._pulsarPosPWM[1] - 500);
		this._pulsarStnPWM.push(this._pulsarPosPWM[2] - 192250);
		this._posStn = Vector3D(this._pulsarStnPWM).fromCoordinateSystem("pwm");
		system.setPopulator("tianve_pulsar_station", {
			callback: function (pos) {
				var pws = worldScripts["oolite-tianve"];
				var pl = Vector3D(pws._pulsarPosPWM).fromCoordinateSystem("pwm");
				pws._posVE = pl;
				var ve = system.addVisualEffect("tianve_pulsar_flashers", pws._posVE);
				ve.orientation = system.mainPlanet.orientation;
				
				var stn = system.addShips("[tianve-pulsar-station]", 1, pos, 0)[0];
				worldScripts["oolite-tianve"].turnStationToEntity(stn, ve);

				// get the main station position as a pwm value
				var msp = Vector3D(system.mainStation.position).toCoordinateSystem("pwm");
				
				// at the main station
				system.addShips("tianve-liner-moving", 1, Vector3D.interpolate(system.mainStation, stn, 0.01));
				system.addShips("tianve-small-billboard-01", 1, Vector3D(msp[0] - 8550, msp[1] - 8500, msp[2] - 3000).fromCoordinateSystem("pwm"));
				system.addShips("tianve-liner-motionless", 1, Vector3D(msp[0] - 7000, msp[1] - 8000, msp[2] - 3000).fromCoordinateSystem("pwm"));

				// At the Witchpoint Marker
				system.addShips("tianve-small-billboard-01", 1, Vector3D(-2500, 2500, 442500).fromCoordinateSystem("pwm"));
				system.addShips("tianve-liner-moving", 1, Vector3D(-3500, 3500, 442500).fromCoordinateSystem("pwm"));

				// Halfway between the Main Station and the Pulsar
				system.addShips("tianve-liner-moving", 1, Vector3D.interpolate(system.mainStation, stn, 0.5));
				system.addShips("tianve-small-billboard-02", 1, Vector3D.interpolate(system.mainStation, stn, 0.5));

				// At the Pulsar
				system.addShips("tianve-liner-moving", 2, pos, 10000);
				system.addShips("tianve-small-billboard-03", 1, Vector3D(pws._pulsarStnPWM[0] + 6500, pws._pulsarStnPWM[1], pws._pulsarStnPWM[2] - 11500).fromCoordinateSystem("pwm"));
				system.addShips("tianve-rebecca", 1, Vector3D(pws._pulsarStnPWM[0], pws._pulsarStnPWM[1] + 10000, pws._pulsarStnPWM[2]).fromCoordinateSystem("pwm"));
			},
			location: "COORDINATES",
			coordinates: this._posStn,
			deterministic: true
		});
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipLaunchedFromStation = function (launchStation) {
	if (launchStation == system.mainStation && system.ID == 246 && galaxyNumber == 0) {
		launchStation.commsMessage(expandMissionText("tianve_visit"), player.ship);
	}
	this.$startTimer();
}

//-------------------------------------------------------------------------------------------------------------
this.shipExitedWitchspace = function () {
	this.$startTimer();
	if (system.ID == 246 && galaxyNumber == 0) {
		var b = system.shipsWithPrimaryRole("buoy-witchpoint")[0];
		if (b) {
			b.commsMessage(expandMissionText("tianve_welcome"), player.ship);
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.playerBoughtEquipment = function (equipmentKey) {
	if (equipmentKey === "EQ_TIANVE_STICKER") {
		mission.setInstructionsKey("tianve_sticker");
		player.ship.removeEquipment("EQ_TIANVE_STICKER");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$startTimer = function() {
	if (this._timer && this._timer.isRunning) this._timer.stop();
	if (this._posVE) {
		this._timer = new Timer(this, this.$checkPosition, 0.5, 0.5);
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$checkPosition = function $checkPosition() {
	if (!this._posVE) {
		this._timer.stop();
		return;
	}
	var p = player.ship;
	var dist = p.position.distanceTo(this._posVE);
	if (dist < 159200) {
		p.temperature += 0.05;
	}
	if (dist < 160000 && !this._massLocker) {
		this._massLocker = system.addShips("tianve-masslocker", 1, player.ship.position.add(player.ship.vectorUp.multiply(300)))[0];
	}
	if (dist >= 160000 && this._massLocker) {
		this._massLocker.remove(true);
		this._massLocker = null;
	}
}
