"use strict";
this.author = "cim";
this.copyright = "© 2011-2014 cim.";
this.license = "CC-BY-SA 3.0";
this.name = "CargoTypeExtension-Station-TianvePulsarStation";
this.description = "Tianve Pulsar Station market definition";

this.startUp = function () {
	if (!worldScripts.CargoTypeExtension) {
		for (var prop in this) {
			if (prop !== 'name' && prop !== 'version' && prop !== "oolite_manifest_identifier") {
				delete this[prop];
			}
		}
		return;
	}
	else {
		worldScripts["CargoTypeExtension"].registerOXPStation(this.name, "tianve-pulsar-station");
		this.$registerNewCargoTypes();
	}
}

this.$registerNewCargoTypes = function () {
	var obj = new Object;
	obj.ID = "TP-LW1";
	obj.genericType = "liquor_wines";
	obj.specificType = expandMissionText("tianve_padlamanggan");
	obj.buySystems = [[246], [], [], [], [], [], [], []];
	obj.sellSystems = [[], [], [], [], [], [], [], []];
	obj.desc = expandMissionText("tianve_padlamanggan_info");

	worldScripts["CargoTypeExtension"].registerCargoType(obj);
}


/* Station API */


this.randomCargoChance = function (good) {
	var generic = worldScripts["CargoTypeExtension"].cargoDefinition(good, "genericType");
	if (generic == "luxuries") {
		return 0.75;
	}
	return 0;
}

this.randomCargoAmount = function (good) {
	return 3;
}

this.exportCargoAmount = function (good) {
	var generic = worldScripts["CargoTypeExtension"].cargoDefinition(good, "genericType");
	if (good == "CTE_CTS_O4" || good == "CTE_CTS_R1" || good == "CTE_CTA_O1" || good == "CTE_CTS_IS1" || good == "TP-LW1") return 2;
	return 0;
}

this.exportCargoPrice = function (good) {
	return 0.9 + (Math.random() * 0.2);
}

this.randomImportChance = function (good) {
	return 0;
}

this.systemImportChance = function (good) {
	var generic = worldScripts["CargoTypeExtension"].cargoDefinition(good, "genericType");
	if (generic == "food" || generic == "liquor_wines" || generic == "luxuries") {
		return 1;
	} else {
		return 0;
	}
}

this.importCargoPrice = function (good) {
	return 0.9 + (Math.random() * 0.2);
}

// they have police patrol ships, so they probably obey Galcop rules here
this.importPermitCheck = function () {
	return true;
}

this.exportPermitCheck = function () {
	return true;
}

this.stationGossip = function () {
	return false;
}
