"use strict";
/*

tianve-line-script.js

Ship script for Tianve Pulsar Liners.

Oolite - Copyright © 2009 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.


Tianve.oxp - Copyright © 2009 Drew Wagar

This work is licensed under the Creative Commons
Attribution-Noncommercial-Share Alike 3.0 Unported License.

To view a copy of this license, visit
http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter
to Creative Commons, 171 Second Street, Suite 300, San Francisco,
California, 94105, USA.

*/

this.name = "tianve-liner-script";
this.author = "phkb";
this.copyright = "© 2023 phkb";
this.license = "CC-by-nc-sa 3.0";

this.linerAIPulsar = function() {
    var pws = worldScripts["oolite-tianve"];
    this.ship.destination = pws._posVE;
}

this.linerAIPoint1 = function () {
    var pws = worldScripts["oolite-tianve"];
    this.ship.destination = Vector3D(pws._pulsarPosPWM[0], pws._pulsarPosPWM[1], pws._pulsarPosPWM[2] - 160500).fromCoordinateSystem("pwm");
}
this.linerAIPoint2 = function () {
    var pws = worldScripts["oolite-tianve"];
    this.ship.destination = Vector3D(pws._pulsarPosPWM[0] - 159800, pws._pulsarPosPWM[1], pws._pulsarPosPWM[2]).fromCoordinateSystem("pwm");
}
this.linerAIPoint3 = function () {
    var pws = worldScripts["oolite-tianve"];
    this.ship.destination = Vector3D(pws._pulsarPosPWM[0], pws._pulsarPosPWM[1], pws._pulsarPosPWM[2] + 159800).fromCoordinateSystem("pwm");
}
this.linerAIPoint4 = function () {
    var pws = worldScripts["oolite-tianve"];
    this.ship.destination = Vector3D(pws._pulsarPosPWM[0] + 159800, pws._pulsarPosPWM[1], pws._pulsarPosPWM[2]).fromCoordinateSystem("pwm");
}

