"use strict";
this.name = "ExtraRockHermit_Spawn";
this.author = "phkb";
this.description = "Looks after setup of extra rock hermits";
this.copyright = "2024 phkb";
this.license = "CC BY-NC-SA 4.0";

this._debug = false;

//----------------------------------------------------------------------------------------
this.shipSpawned = function() {
    if (this._debug) log(this.name, "extra rock hermit spawning in " + system.name + " for role " + this.ship.primaryRole);

    var num = system.sun["_erh_" + this.ship.primaryRole]; //system.countShipsWithRole(this.ship.primaryRole);
    if (!num) num = 0;

    // pick from our available rock textures
    var textures = ["griff_erh_rock1", "griff_erh_rock2", "griff_erh_rock3", "griff_erh_rock4"];
    var seed = (system.ID + this.ship.primaryRole.length) * 2;
    var rocktype = (parseInt(system.scrambledPseudoRandomNumber(seed) * 4) + num) % 4;
    var diff = textures[rocktype] + ".png";
    var norm = textures[rocktype] + "_normal.png";
    var spec = textures[rocktype] + "_specular.png";

    if (this._debug) log(this.name, "using " + diff + " for rock texture (" + num + " rh's in system)");
    // set the materials for the rh
    this.ship.setMaterials({"griff_spacebar_rock.png":{
        diffuse_map:diff,
        normal_map:norm,
        specular_map:spec,
        gloss:0.4,
        specular_color:[0.1, 0.1, 0.1, 1.0]}
    });

    var subents = this.ship.subEntities;
    var tl = system.techLevel;
    // make it possible for other rock hermits to have other styles by having a completely random roll for chaotic and pirate roles
    if (this.ship.primaryRole == "rockhermit-chaotic") tl = (tl + parseInt(system.scrambledPseudoRandomNumber(77) * 15)) % 15;
    if (this.ship.primaryRole == "rockhermit-pirate") tl = (tl + parseInt(system.scrambledPseudoRandomNumber(88) * 15)) % 15;
    var style = (parseInt((tl + 1) / 6) + num) % 6;
    this.ship._rhStyle = style;
    if (this._debug) log(this.name, "setting style to " + style);

    var eds = worldScripts.ExternalDockSystem;
    var rem = [];
    switch (style) {
        // style 0 - no extras
        case 0: rem = [2,3,4,5,6]; break;
        // style 1 - main building only
        case 1: rem = [5,6]; break;
        // style 2 - external dock only
        case 2: rem = [2,3,4,5]; break;
        // style 3 - main building and external dock
        case 3: rem = [5]; break;
        // style 4 - main building plus back section
        case 4: rem = [6]; break;
        // style 5 - main building plus back section plus external dock - don't remove anything
        case 5: rem = []; break;
    }
    var i = rem.length;
    while (i--) {
        subents[rem[i]].remove();
    }
    
    // if we've got a landing pad and eds is installed, set up the external dock
    if (eds && rem.indexOf(6) == -1) {
        this.$registerExternalDocks(this.ship);
    } else {
        this.$removeExternalDockFlashers();
    }
    num += 1;
    system.sun["_erh_" + this.ship.primaryRole] = num;
}

//----------------------------------------------------------------------------------------
// get rid of the flashers on the external dock
this.$removeExternalDockFlashers = function() {
    var fa = this.ship.flashers;
    var last = fa.length;
    while (last--) {
        fa[last].remove();
        if (last == 10) break;
    }
}

//----------------------------------------------------------------------------------------
// registers our external docks with the eds
this.$registerExternalDocks = function () {
    // set up the timer to let the player know about the docks
    if (this._timer && this._timer.isRunning) this._timer.stop();
    this._timer = new Timer(this, this.$externalDockNotification, 2, 2);

    var eds = worldScripts.ExternalDockSystem;
    eds.$addExternalDock({station:this.ship, position:[-550, 0, 22], scale:0.5, preDockCallback:this.$preDockSetup.bind(this)});
}

//----------------------------------------------------------------------------------------
this.$preDockSetup = function(station) {
    // docking at the external port will still get you transferred inside
    player.addMessageToArrivalReport(expandDescription("[erh_redocked]"));
}

//----------------------------------------------------------------------------------------
this.$externalDockNotification = function $externalDockNotification() {
	if (this._externalDockNotification == false) {
		if (this.ship.position.distanceTo(player.ship) < player.ship.scannerRange * 0.85) {
			this.ship.commsMessage(expandDescription("[erh_external_dock]"), player.ship);
			this._externalDockNotification = true;
		}
	} else {
		this._timer.stop();
	}
}
