"use strict";
this.name = "ERH_Condition_Script";
this.author = "phkb";
this.copyright = "2024 phkb";
this.license = "CC BY-NC-SA 4.0";

//----------------------------------------------------------------------------------------
this.allowSpawnShip = function(shipKey) {
    // don't get in the way of Commies spawning routines
    if (system.government == 4 && worldScripts["communist_population"]) return false;
    var seed = 230; // default for erh_standard
    switch (shipKey) {
        case "erh_chaotic": seed = 240; break;
        case "erh_pirate": seed = 250; break;
    }
    var check = system.scrambledPseudoRandomNumber(seed + this.$totalRockHermits(shipKey));
    return (check < 0.35);
}

//----------------------------------------------------------------------------------------
this.$totalRockHermits = function(shipKey) {
    switch (shipKey) {
        case "erh_standard": return system.countShipsWithRole("rockhermit");
        case "erh_chaotic": return system.countShipsWithRole("rockhermit-chaotic");
        case "erh_pirate": return system.countShipsWithRole("rockhermit-pirate");
    }
    return 0;
}
