"use strict";
this.name = "ERH_Corrections";
this.author = "phkb";
this.copyright = "2024 phkb";
this.license = "CC BY-NC-SA 4.0";

// in some circumstances, when using the old version of Pirate Coves, an extra rock hermit
// can become a pirate cove. To me this doesn't make sense, as the roles would seem to make this
// impossible. But it appears to be happening to others, if not me.
// These routines will apply a small correction to those ERH stations that end up being pirate coves.
// Because they will have all subentities defined, we just add the missing property to the ship
// which VimanaX HUD can pick up and so display the correct ship image.

this.systemWillPopulate = function() {
    this._onceOnly = true;
}

this.systemWillRepopulate = function() {
    if (this._onceOnly == true) {
        this._onceOnly = false;
        var rhn = system.shipsWithRole("extrarockhermit")
        for (var i = 0; i < rhn.length; i++) {
            if (rhn[i].script.name != "ExtraRockHermit_Spawn") {
                // found one
                rhn[i]._rhStyle = 5; // default - has everything
            }
        }
    }
}
