"use strict";
this.name = "Permit_Conditions";
this.author = "phkb";
this.copyright = "2015 phkb";
this.description = "Condition script for determining whether to include the 'Import permit' item on the F3 screen";
this.licence = "CC BY-NC-SA 3.0";

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function (equipment, ship, context) {

	if (player.ship.dockedStation.allegiance != "galcop") return false;
	var result = true;

	switch (equipment) {
		case "EQ_IMPORT_PERMIT_NC":
		case "EQ_IMPORT_PERMIT":
			if (equipment == "EQ_IMPORT_PERMIT_NC" && !worldScripts.CargoTypeExtension) return false;
			if (equipment == "EQ_IMPORT_PERMIT" && worldScripts.CargoTypeExtension) return false;
			
			var si = worldScripts.Smugglers_Illegal;
			var goods = si.$illegalGoodsList(system.ID);

			// are there any illegal goods in this system
			if (goods.length === 0) {
				return false;
			}
			// does the player already have permits for all the goods?
			var count = 0;
			var permitavail = 0;
			for (var i = 0; i < goods.length; i++) {
				if (goods[i].permit === 1) {
					permitavail += 1;
					if (si.$playerHasPermit(system.ID, goods[i].commodity) === true) {
						count += 1;
						permitavail -= 1;
					}
				}
			}
			if (count === goods.length) result = false;
			if (permitavail <= 0) result = false;

			break;
	}

	// otherwise allowed
	return result;

}