"use strict";
this.name           = "in_system_market_restore";
this.author         = "spara & Stranger";
this.copyright      = "2013 Mika Spåra, 2015 Stranger";
this.description    = "Remember and restore non main station prices and quantities. Modified by Stranger to adopt extra trade items.";
this.version        = "1.2.1";
this.licence    	= "CC BY-NC-SA 3.0";

//1.1 save every market on save and restore when spawning. now it's fully compatible with market inquirer.

this.startUp = function() {
	if (missionVariables.marketRestorePrimaryRoles) {
		this.$primaryRoles = JSON.parse(missionVariables.marketRestorePrimaryRoles);
		this.$markets = JSON.parse(missionVariables.marketRestoreMarkets);
	}
	else {
		this.$primaryRoles = new Array();
		this.$markets = new Array();
		delete this.shipSpawned;
	}
}

//restore market when station is spawned
this.shipSpawned = function(ship) {
	if (ship.isStation) {
		var index = this.$primaryRoles.indexOf(ship.primaryRole);
		if (index !== -1) {
			var commodities  = ["food","textiles","liquor_wines","furs","medicine","luxuries","alloys","machinery","computers","water","oxygen","minerals","radioactives","gold","platinum","gem_stones","alien_items","slaves","narcotics","firearms"];		
			var market = this.$markets.splice(index, 1)[0];
			var i, commodity;
			for (i = 0; i < market.length; i++) {
				commodity = commodities[i];
				ship.setMarketQuantity(commodity, market[i][0]);
				ship.setMarketPrice(commodity, market[i][1]);
			}
			this.$primaryRoles.splice(index, 1);
		}		
	}
}

//wipe everything when leaving system
this.shipWillEnterWitchSpace = function() {
	this.$primaryRoles = new Array();
	this.$markets = new Array();
	delete this.shipSpawned;
}

//save primaryRoles and markets (prices and quantities) of all stationary stations
this.playerWillSaveGame = function() {
	function stations(entity) {return (entity.isStation && !entity.isMainStation && !entity.maxSpeed)};
	var i, j, station, commodity;
	var stationMarket = new Array();
	var primaryRoles = this.$primaryRoles.concat();
	var markets = this.$markets.concat();
	var commodities  = ["food","textiles","liquor_wines","furs","medicine","luxuries","alloys","machinery","computers","water","oxygen","minerals","radioactives","gold","platinum","gem_stones","alien_items","slaves","narcotics","firearms"];	
	var oxpStations = system.filteredEntities(this, stations, player.ship);
	for (i = 0; i < oxpStations.length; i++) {
		station = oxpStations[i];
		primaryRoles.push(station.primaryRole);
		stationMarket = new Array();
		for (j = 0; j < commodities.length; j++) {
			commodity = commodities[j];
			stationMarket.push([station.market[commodity].quantity, station.market[commodity].price]);
		}
		markets.push(stationMarket);
	}
	if (primaryRoles.length > 0) {
		missionVariables.marketRestorePrimaryRoles = JSON.stringify(primaryRoles);
		missionVariables.marketRestoreMarkets = JSON.stringify(markets);
	}
	else {
		delete missionVariables.marketRestorePrimaryRoles;
		delete missionVariables.marketRestoreMarkets;
	}
}