"use strict";
this.name = "Smugglers_Oolite_Contracts_Fix";
this.author = "phkb";
this.description = "Fixes the Oolite Cargo contracts system so it doesn't pick illegal commodities.";
this.licence = "CC BY-NC-SA 3.0";

this.startUp = function () {
	var w = worldScripts["oolite-contracts-cargo"];
	w.$hide = w._initialiseCargoContractsForSystem;
	if (w.author.indexOf("Switeck") >= 0) {
		w._initialiseCargoContractsForSystem = this.$switech_initialiseCargoContractsForSystem;
	} else {
		w._initialiseCargoContractsForSystem = this.$core_initialiseCargoContractsForSystem;
	}
}

// initialise a new cargo contract list for the current system
this.$core_initialiseCargoContractsForSystem = function $core_initialiseCargoContractsForSystem() {
	// clear list
	this.$contracts = [];

	// this is not the same algorithm as in 1.76, but should give
	// similar results with comparable efficiency.

	// no point in generating too many, as route-finding is slow
	var numContracts = Math.floor(5 * Math.random() + 5 * Math.random() + 5 * Math.random() + (player.contractReputationPrecise * Math.random()));
	if (player.contractReputationPrecise >= 0 && numContracts < 5) {
		numContracts += 5;
	}
	if (numContracts > 16) {
		numContracts = 16;
	} else if (numContracts < 0) {
		numContracts = 0;
	}
	// some of these possible contracts may be discarded later on

	for (var i = 0; i < numContracts; i++) {
		var cargo = new Object;

		// pick a random system to take the goods to
		var destination = Math.floor(Math.random() * 256);

		// discard if chose the current system
		if (destination === system.ID) {
			continue;
		}

		// get the SystemInfo object for the destination
		var destinationInfo = System.infoForSystem(galaxyNumber, destination);
		if (destinationInfo.sun_gone_nova) {
			continue;
		}
		var daysUntilDeparture = 1 + (Math.random() * (7 + player.contractReputationPrecise - destinationInfo.government));
		if (daysUntilDeparture <= 0) {
			// loses some more contracts if reputation negative
			continue;
		}

		var si = worldScripts.Smugglers_Illegal;
		var illegal = null;
		if (si) {
			illegal = si.$illegalGoodsListCommodityOnly(destination, true);
			// add slaves to the list
			illegal.push("slaves");
		}

		var commodities = Object.keys(system.mainStation.market);
		var attempts = 0;
		do {
			var remotePrice = 0;
			attempts++;
			var commodity = commodities[Math.floor(Math.random() * commodities.length)];
			// sub-tc contracts only available for top rep
			if (system.mainStation.market[commodity]["quantity_unit"] != 0 && player.contractReputationPrecise < 6.5) {}
			// ignore commodities with 0 availability here
			else if (system.mainStation.market[commodity].quantity === 0) {}
			// ignore any illegal goods
			else if (illegal && illegal.indexOf(commodity) >= 0) {} else {
				remotePrice = this._priceForCommodity(commodity, destinationInfo);
			}
		} while (remotePrice < system.mainStation.market[commodity].price / 20 && attempts < 10);
		if (attempts === 10) {
			// failed to find a good one.
			continue;
		}
		cargo.commodity = commodity;

		var amount = 0;
		while (amount < 30) {
			var unitsize = 1;
			// larger unit sizes for kg/g commodities
			if (system.mainStation.market[commodity]["quantity_unit"] === 1) {
				unitsize += Math.floor(Math.random() * 6) + Math.floor(Math.random() * 6) + Math.floor(Math.random() * 6);
			} else if (system.mainStation.market[commodity]["quantity_unit"] === 2) {
				unitsize += Math.floor(Math.random() * 16) + Math.floor(Math.random() * 11) + Math.floor(Math.random() * 6);
			}
			amount += (1 + Math.floor(Math.random() * 32)) * (1 + Math.floor(Math.random() * 16)) * unitsize;
		}

		if (amount > 125 && system.mainStation.market[commodity]["quantity_unit"] === 0) {
			// reduce the number of contracts only suitable for Anacondas
			amount = Math.floor(amount / Math.floor(1 + (Math.random() * 4)));
		}
		cargo.size = amount;

		// adjustment to prices based on quantity (larger = more profitable)
		var discount = Math.min(10 + Math.floor(amount / 10), 35);

		var unitPrice = system.mainStation.market[commodity].price * (100 - discount) / 1000;
		var localValue = Math.floor(unitPrice * amount);
		remotePrice = remotePrice * (200 + discount) / 200;
		var remoteValue = Math.floor(remotePrice * amount);
		var profit = remoteValue - localValue;

		// skip if unprofitable
		if (profit <= 100) {
			continue;
		}

		// check that a route to the destination exists
		// route calculation is expensive so leave this check to last
		var routeToDestination = system.info.routeToSystem(destinationInfo);

		// if the system cannot be reached, ignore this contract
		if (!routeToDestination) {
			continue;
		}

		// we now have a valid destination, so generate the rest of
		// the parcel details

		cargo.destination = destination;
		// we'll need this again later, and route calculation is slow
		cargo.route = routeToDestination;

		// higher share for transporter for longer routes, less safe systems
		var share = 100 + destinationInfo.government - (10 * routeToDestination.route.length);
		if (share < 10) {
			share = 10;
		}
		share = 100 - share;

		// safety: now multiply the fee by 2 compared with 1.76 contracts
		// prevents exploit discovered by Mad Hollander at
		// http://bb.oolite.space/viewtopic.php?p=188127
		localValue *= 2;
		// this may need to be raised further

		// absolute value of profit remains the same
		var fee = localValue + Math.floor(profit * (share / 100));
		fee -= fee % 20; // round to nearest 20 credits;

		cargo.payment = fee;
		cargo.deposit = localValue - (localValue % 20);
		if (cargo.deposit >= cargo.payment) {
			// rare but not impossible; last safety check
			return;
		}

		// time allowed for delivery is time taken by "fewest jumps"
		// route, plus timer above. Higher reputation makes longer
		// times available.
		cargo.deadline = clock.adjustedSeconds + Math.floor(daysUntilDeparture * 86400) + (cargo.route.time * 3600);

		// add parcel to contract list
		this._addCargoContractToSystem(cargo);
	}

}

// initialise a new cargo contract list for the current system
this.$switech_initialiseCargoContractsForSystem = function $switech_initialiseCargoContractsForSystem() {
	// clear list
	this.$contracts = [];

	// this is not the same algorithm as in 1.76, but should give similar results with comparable efficiency.

	// no point in generating too many, as route-finding is slow
	var numContracts = Math.floor(5 * (Math.random() + Math.random()) + (system.government + player.contractReputationPrecise - player.bounty * 0.02) * Math.random());
	// I added that bounty can reduce the number of contracts. Corporate state systems can add extra contracts.
	if (numContracts < 0) numContracts = 0;
	if (player.contractReputationPrecise >= 0 && numContracts < 5) numContracts += 5;
	if (numContracts > 18) numContracts = 18;

	// some of these possible contracts may be discarded later on
	var nearbysystems = system.info.systemsInRange(80 - player.contractReputationPrecise * 7); // 31-80-129 LY range...done here to save recalculations time.

	log(this.name, " player.contractReputation= " + player.contractReputationPrecise + " numContracts= " + numContracts + " nearbysystems.length= " + nearbysystems.length);
	//	log(this.name," player.contractReputation= "+player.contractReputation+" numContracts= "+numContracts+" nearbysystems.length= "+nearbysystems.length+" nearbysystems= "+nearbysystems);

	for (var i = 0; i < numContracts; i++) {
		var scratchval = 1;
		var attempts = 0;
		do {
			var scratchval = 1;
			attempts++;
			// pick a random system to take the goods to
			//			var destination = Math.floor(Math.random()*256);	// ORIGINAL -- FOR TESTING ONLY!
			var destination = nearbysystems[Math.floor(Math.random() * nearbysystems.length)].systemID;
			//		log(this.name," destination = "+destination);

			// discard if chose the current system
			if (destination === system.ID) {
				var scratchval = 0;
			} else {
				// get the SystemInfo object for the destination
				var destinationInfo = System.infoForSystem(galaxyNumber, destination);

				// Decides firsthand to drop a bad system and choose another one?
				if (Math.abs(system.economy - destinationInfo.economy) < (1 + player.contractReputationPrecise * 0.28) && player.contractReputationPrecise < 6.5 && system.economy < 7) {
					var scratchval = 0; // Discarded, since identical or "worse" economies leave little opportunity for profitable trading.

				} else {
					// check that a route to the destination exists
					// route calculation is expensive so leave this check to last
					var routeToDestination = system.info.routeToSystem(destinationInfo);
					//log(this.name," routeToDestination = "+routeToDestination);
					// if the system cannot be reached, ignore this contract
					if (!routeToDestination) {
						var scratchval = 0; // No route, no point trying!
					} else {
						var daysUntilDeparture = 1 + (Math.random() * (7 + player.contractReputationPrecise - destinationInfo.government)); // NEEDS a better estimate based on time needed to reach target!
						if (daysUntilDeparture < 0) var scratchval = 0; // negative reputation can make a contract out-of-time failed before starting.
					}
				}
			}
		} while (scratchval === 0 && attempts < 10);
		if (attempts > 9) continue; // failed to find a good destination.

		// we now have a valid destination, so generate the rest of the cargo contract details

		//log(this.name," daysUntilDeparture = "+daysUntilDeparture);
		//		var commodities = Object.keys(system.mainStation.market);
		var attempts = 0;
		do {
			var unitPrice = 0;
			var unitMinPrice = 0;
			var unitMaxPrice = 0;
			var remotePrice = 0;
			var remoteMinPrice = 0;
			attempts++;

			// if destinationInfo.economy < system.economy	means destination is more industrial than start locaction.
			// if system.economy <4 then it's "industrial" so choose comp,lux,mach,alloys (+firearms?)
			// else it's "agricultural" so choose food,textiles,radioactives,liquor_wines,furs,minerals (+slaves, narcotics?)
			// Odds get lowered if offender/fugitive, raised if high reputation...forcing more controlled items if "bad" and more gold/plat/gems if "good".

			//			var commodities = ["food","textiles","radioactives","slaves","liquor_wines","luxuries","narcotics","computers","machinery","alloys","firearms","furs","minerals","gold","platinum","gem_stones"];
			//			var commodity = commodities[Math.floor(Math.random()*commodities.length)];	// Chooses random commondity
			if (system.economy > destinationInfo.economy || system.economy > 5) {
				if (system.economy < destinationInfo.economy + 1 + player.contractReputationPrecise * 0.4) { // Eliminates marginal profit commodities from similar agri economies
					var commodities = ["slaves", "narcotics", "liquor_wines", "alloys", "furs", "platinum", "gem_stones"]; // 7 entries, removed Gold!
					var preccutoff = 5;
					var scratchval = Math.floor(Math.random() * (commodities.length - 3) + 3); // Drops the controlled items and low profit stuff.
				} else {
					var commodities = ["slaves", "narcotics", "food", "minerals", "textiles", "radioactives", "liquor_wines", "furs", "gold", "platinum", "gem_stones"]; // 11 entries, sorted from worst to best
					var preccutoff = 8;
					var scratchval = Math.floor(Math.random() * (commodities.length - 5) + 5); // Drops the controlled items and low profit stuff.
				}
			} else if (system.economy > destinationInfo.economy - Math.max(0, player.contractReputationPrecise * 0.3)) { // Eliminates low-profit commodities when start economy === destination (identical ind economies)
				var commodities = ["alloys", "furs", "gold", "platinum", "gem_stones"]; // 5 entries
				var preccutoff = 2;
				var scratchval = Math.floor(Math.random() * commodities.length);
			} else if (system.economy > destinationInfo.economy - 1 - player.contractReputationPrecise * 0.2) { // Eliminates low-profit commodities when start economy is only slightly more industrial than destination.
				var commodities = ["narcotics", "firearms", "computers", "alloys", "furs", "platinum", "gem_stones"]; // 7 entries, removed Gold!
				var preccutoff = 5;
				var scratchval = Math.floor(Math.random() * (commodities.length - 2) + 2); // Drops the controlled items and low profit stuff.
			} else {
				var commodities = ["narcotics", "firearms", "alloys", "machinery", "luxuries", "computers", "platinum", "gem_stones"]; // 8 entries, sorted from worst to best, removed Gold!
				var preccutoff = 6;
				var scratchval = Math.floor(Math.random() * (commodities.length - 2) + 2); // Drops the controlled items and low profit stuff.
			}

			if (player.contractReputationPrecise < 6.5 - Math.random() * 5) { // At rep>2, there's a chance of getting ONLY good contracts. The odds of this are much better by rep>5.
				var scratchval = Math.floor(Math.random() * (preccutoff + player.contractReputationPrecise * 0.1 - player.bounty * 0.01));
			}

			if (scratchval < 0) var scratchval = 0; // If bad rep plus bad bounty pushes off leftside of the chart, give player "worst" contract.
			if (scratchval >= preccutoff && player.contractReputationPrecise < 6.5) var scratchval = preccutoff - 1; // Prevents Gold contracts before player.contractReputation === 7
			if (scratchval > commodities.length - 1) var scratchval = commodities.length - 1; // If high rep pushes off rightside of the chart, give player "best" contract.

			//			var commodities = ["gold","platinum","gem_stones"];	// 3 entries, tests only Gold/Plat/Gems!
			//			var scratchval = Math.floor(Math.random()*commodities.length);
			var commodity = commodities[scratchval];

			var si = worldScripts.Smugglers_Illegal;
			var illegal = null;
			if (si) {
				illegal = si.$illegalGoodsListCommodityOnly(destination, true);
				// add slaves to the list
				illegal.push("slaves");
			}

			if (illegal && illegal.indexOf(commodity) >= 0) { // don't pick commodities illegal at the destination
				if (system.mainStation.market[commodity].quantity > 0) { // ignore commodities with 0 availability here
					var unitPrice = Number((system.mainStation.market[commodity].price * 0.1).toFixed(1));
					var unitMinPrice = Number((this._priceForCommodity(system.mainStation.market[commodity], System.infoForSystem(galaxyNumber, system.ID).economy, 0)).toFixed(1));
					var unitMaxPrice = Number((this._priceForCommodity(system.mainStation.market[commodity], System.infoForSystem(galaxyNumber, system.ID).economy, 255)).toFixed(1));
					var remoteMinPrice = Number((this._priceForCommodity(system.mainStation.market[commodity], destinationInfo.economy, 0)).toFixed(1)); // ,0 means return smallest value
					var remotePrice = Number((this._priceForCommodity(system.mainStation.market[commodity], destinationInfo.economy, 255)).toFixed(1)); // ,255 means return largest value
					//				var remotePrice = Number((this._priceForCommodity(system.mainStation.market[commodity],destinationInfo.economy,Math.floor(Math.random()*256))).toFixed(1)); // random prices!

					//		log(this.name," # "+attempts+", "+commodities+", "+preccutoff+", "+commodity+" val1="+scratchval+" Price="+unitPrice+" MinPrice="+unitMinPrice+" MaxPrice="+unitMaxPrice+" remMin="+remoteMinPrice+" remP= "+remotePrice+", "+system.economy+", "+destinationInfo.economy);

					// This can happen with narcotics!
					if (remotePrice < remoteMinPrice) {
						var scratchval = remoteMinPrice;
						var remoteMinPrice = remotePrice;
						var remotePrice = scratchval;
					}
					if (unitMaxPrice < unitMinPrice) {
						var scratchval = unitMaxPrice;
						var unitMaxPrice = unitMinPrice;
						var unitMinPrice = scratchval;
					}
					if (unitPrice < unitMinPrice) unitMinPrice = unitPrice;
					if (unitPrice > unitMaxPrice) unitMaxPrice = unitPrice;
				}
			}
		} while ((remotePrice - unitMinPrice) < Math.max(1, player.contractReputationPrecise * 0.5 - system.mainStation.market[commodity].quantityUnit * 3) && attempts < 10); // Allows Gold more often!
		if (attempts > 9) continue; // failed to find a good commodity.

		var cargo = new Object;
		cargo.commodity = commodity;

		var amount = 0;
		var unitsize = 1;
		// larger unit sizes for kg/g commodities
		if (system.mainStation.market[commodity].quantityUnit === 1) {
			unitsize += Math.ceil((Math.random() + Math.random() + Math.random()) * routeToDestination.route.length); // Adds more if routeToDestination.route.length > 5
		} else if (system.mainStation.market[commodity].quantityUnit === 2) {
			unitsize += Math.ceil((Math.random() + Math.random() + Math.random()) * routeToDestination.route.length * 2);
		}
		amount += Math.max(Math.ceil((1 + Math.random() * 32) * (1 + Math.random() * 16)), Math.floor(30 + Math.random() * 6)) * unitsize; // forced minimum amount to always be at least 30-35. Eliminates while-looping here!

		if (amount > 125 && amount > player.ship.cargoSpaceCapacity && player.contractReputationPrecise >= 0 && system.mainStation.market[commodity].quantityUnit === 0) { // reduce the number of contracts only suitable for Anacondas
			amount = Math.floor(amount / Math.floor(1 + (Math.random() * 4)));
		}

		cargo.size = amount;

		var localValue = Math.floor(unitPrice * amount); // Total cost at Current/Original Price
		var remoteValue = Math.floor(remotePrice * amount); // Remote max value
		var profitMax = remoteValue - Math.floor(unitMinPrice * amount);

		// discount adjustment to prices. Higher reputation and bulk quantities should make this more profitable
		var discount = Number((Math.ceil(Math.max(50, Math.min(100, 20 + player.contractReputationPrecise * 10 + routeToDestination.route.length * 10 + amount * 0.1 + 50000 / profitMax - player.bounty * 0.1 - destinationInfo.government - system.government))) * 0.01).toFixed(2));
		var profit = Math.ceil(profitMax * discount); // Uses discount directly on max profit to determine profit.
		//		if (profit < 100 + player.contractReputationPrecise*100 || profit > profitMax) profit = profitMax;	// Ensures higher profits if payout would otherwise be too low.

		// Formulas to generate ORIGINAL PROFIT AMOUNTS!
		/*
				var discount = Math.min(10+Math.floor(amount/10),35);
				var unitPrice = system.mainStation.market[commodity].price * (100-discount) / 1000;
				var localValue = Math.floor(unitPrice * amount);
				remotePrice = remotePrice * (200+discount) / 200;
				var remoteValue = Math.floor(remotePrice * amount);
				var profit = remoteValue-localValue;
		*/
		var scratchval = this._priceForCommodity(system.mainStation.market[commodity], destinationInfo.economy, Math.floor(Math.random() * 256)); // random prices!
		//		var scratchval = remotePrice; // max selling price!
		var discount2 = Number(Math.min(0.1 + Math.floor(amount * 0.1) * 0.01, 0.35).toFixed(2));
		var profitORG = Math.floor(scratchval * (1 + 0.5 * discount2) * amount) - Math.floor(unitPrice * (1 - discount2) * amount); // Original results for profit!
		var profitORGmax = Math.floor(remotePrice * (1 + 0.5 * discount2) * amount) - Math.floor(unitMinPrice * (1 - discount2) * amount); // Theoretical MAX Original results for profit!

		// higher share for transporter for longer routes, less safe systems, and Higher reputation. lower share for high bounty! 100 bounty = 10% share loss!
		var share = 100 + destinationInfo.government - (10 * routeToDestination.route.length);
		if (share < 10) share = 10;
		if (share > 100) share = 100;
		share = 100 - share;
		var profitORGmax = Math.floor(profitORGmax * share * 0.01);

		// safety: now multiply the fee by 2 compared with 1.76 contracts
		// prevents exploit discovered by Mad Hollander at
		// http://bb.oolite.space/viewtopic.php?p=188127
		//	localValue *= 2;	// This amount is so high in the event of a failed contract that it's practically PUNATIVE PUNISHMENT for those doing contracts.
		// this may need to be raised further

		// fee is total selling price.
		// This IF-ELSE makes the cargo deposit equal or greater than the current selling value for the commodity.
		if (localValue > remoteValue - profit) {
			var fee = Math.ceil((localValue + profit) * 0.1) * 10; // round to nearest 10 credits
		} else {
			var fee = Math.ceil(remoteValue * 0.1) * 10; // round to nearest 10 credits
		}
		cargo.payment = fee;
		cargo.deposit = Math.ceil((fee - profit) * 0.1) * 10; // round to nearest 10 credits

		// logs nearly everything
		log(this.name,
			"Rep=" + player.contractReputationPrecise +
			", " + commodity +
			" size=" + cargo.size +
			" econ=" + system.economy +
			" DestEcon=" + destinationInfo.economy +
			" jumps=" + routeToDestination.route.length +
			" unitPrice=" + unitPrice +
			" MinP=" + unitMinPrice +
			" MaxP=" + unitMaxPrice +
			" remMinP=" + remoteMinPrice +
			" remP=" + remotePrice +
			" locVal=" + localValue +
			" deposit=" + cargo.deposit +
			" profit=" + profit +
			" pMax=" + profitMax +
			" *" + discount +
			" pORG=" + profitORG +
			" pORGmax=" + profitORGmax +
			" share=" + share +
			" discount=" + discount2 +
			" DestVal=" + remoteValue +
			" Total=" + fee
		);

		cargo.destination = destination;
		// we'll need this again later, and route calculation is slow
		cargo.route = routeToDestination;

		// time allowed for delivery is time taken by "fewest jumps"
		// route, plus timer above. Higher reputation makes longer
		// times available.
		cargo.deadline = clock.adjustedSeconds + Math.floor(daysUntilDeparture * 86400) + (cargo.route.time * 3600);

		// add parcel to contract list
		if (cargo.deposit < cargo.payment) this._addCargoContractToSystem(cargo);
	}
}