"use strict";
this.name = "Famous_Planets_PF2_landing_sites";
this.author = "Cholmondely";
this.copyright = "2025 Cholmondely";
this.description = "Creates custom surface locations using PlanetFall2";
this.license = "CC-BY-SA-NC 4.0";
this.startUp = function()

// Galaxy 1 - Santaari

{
	var pf = worldScripts.PlanetFall2;
	pf._locationOverrides["0 4"] =
	{
		main: [ // Xequerin
			{
			roles: ["capitalCity", "leisureComplex",],
			names: ["Goobix (Capital city spaceport)", "Mount Lexuqberen Shrine (Visitor's Centre)",],
			}, ],
	};
	pf._locationOverrides["0 5"] =
	{
		main: [ // Tiraor
			{
			roles: ["capitalCity", "leisureComplex", "capitalCity", "factory", "dump",],
			names: ["Bok (Capital city spaceport)", "People’s National Sports Stadium", "Decapolis spaceport", "Luthien refinery", "Laurent sewage plant (radioactive district)",],
			}, ],
	};
	pf._locationOverrides["0 23"] =
	{
		main: [ // Onrira
			{
			roles: ["capitalCity", "capitalCity", "capitalCity", "factory", "factory", "factory", "dump",],
			names: ["Krienkepolis (Capital city spaceport)", "Obnoxicorpolis (City spaceport)", "Calakul (City spaceport)", "Spalder and Starblaze Inc.", "Faulcon de Lacy labs", "Khan Corporation", "Podalirius mines (radioactive district)",],
			}, ],
	};
	pf._locationOverrides["0 28"] =
	{
		main: [ // Arexe
			{
			roles: ["capitalCity", "capitalCity", "capitalCity", "capitalCity", "capitalCity",],
			names: ["Rexona (Floating spaceport)", "Bander Seri Begawan (City on poles)", "New Dunwich", "Pisa", "Neo-Harappa",],
			}, ],
	};
	pf._locationOverrides["0 35"] =
	{
		main: [ // Isence
			{
			roles: ["capitalCity", "capitalCity", "leisureComplex", "",],
			names: ["Ondaluse (City spaceport)", "Vorhusith (City spaceport)", "Borthanian Tea Plantations (Tourist Resort)", "",],
			}, ],
	};
	pf._locationOverrides["0 39"] =
	{
		main: [ // Reorte
			{
			roles: ["capitalCity", "capitalCity", "factory", "factory",],
			names: ["Fennervich (Main spaceport)", "Kittering (City spaceport)", "Faulcon Manspace", "Raddlett and Rayburn Shipyards",],
			}, ],
	};
	pf._locationOverrides["0 42"] =
	{
		main: [ // Anarlaqu
			{
			roles: ["capitalCity", "leisureComplex", "leisureComplex",],
			names: ["Doria (Capital city spaceport)", "Eigrpan Sports Stadium", "Carolina Coral Reefs",],
			}, ],
	};
	pf._locationOverrides["0 50"] =
	{
		main: [ // Aesbion
			{
			roles: ["capitalCity", "leisureComplex", "capitalCity", "factory", "militaryBase", "militaryBase",],
			names: ["Shisholi (Capital city spaceport)", "Riaraarri Sports Stadium", "Gequla City", "Orarinat Silicon foundries", "Black Barracks (Military)", "Western Fort (Military)",],
			}, ],
	};
	pf._locationOverrides["0 66"] =
	{
		main: [ // Ascension (was Sori)
			{
			roles: ["capitalCity", "capitalCity", "capitalCity", "factory", "leisureComplex", "leisureComplex",],
			names: ["Transcendence (Capital city spaceport)", "Supervenience (city spaceport)", "Exaltation (city spaceport)", "Genetics Labs (Industrial City)",
"Homes of the Hermits (Tourist site)", "Museum of Mankind (Tourist site)",],
			}, ],
	};
	pf._locationOverrides["0 89"] =
	{
		main: [ // Beusrior - Effect: snowstorms? 
			{
			roles: ["capitalCity", "capitalCity", "factory", "",],
			names: ["New London (Capital city spaceport)", "Goobix (city spaceport)", "Crystal Plains depot (Warehousing complex)", "",],
			}, ],
	};
	pf._locationOverrides["0 100"] =
	{
		main: [ // Vetitice - Effect: Parking Meters?
			{
			roles: ["capitalCity", "factory", "factory", "factory", "leisureComplex",],
			names: ["NewBegin (Capital city spaceport)", "Fort Snowdon (industrial city)", "GASEC works", "Skavurzka Shipyards", "Strayhorn mountain caverns (Tourism)",],
			}, ],
	};
	pf._locationOverrides["0 101"] =
	{
		main: [ // Laenin
			{
			roles: ["capitalCity", "capitalCity", "leisureComplex",],
			names: ["Peoplesville (Capital city spaceport)", "Utopia (city spaceport)", "Mausoleum of the Maker (Tetrahedral Shrine)",],
			}, ],
	};
	pf._locationOverrides["0 111"] =
	{
		main: [ // Reinen/Raenin
			{
			roles: ["capitalCity", "factory", "factory", "factory", "leisureComplex",],
			names: ["New Boorlin (Capital city spaceport)", "Quuma Breweries", "Enener Breweries", "Iseron mines", "Letibein Pallisades (Visitor's Centre)",],
			}, ],
	};
	pf._locationOverrides["0 124"] =
	{
		main: [ // Tionisla
			{
			roles: ["capitalCity", "capitalCity", "capitalCity", "factory", "leisureComplex",],
			names: ["Aa (Capital city shuttleport)", "Sodibi (city spaceport)", "Oronla (city spaceport)", "Sirrane Starworks", "Camp Carter (Visitor's Centre)",],
		}, ],
	};
	pf._locationOverrides["0 129"] =
	{
		main: [ // Zaonce (Effects: Hurricane Kev, Volcano del Plasma)
			{
			roles: ["capitalCity", "capitalCity", "leisureComplex", "leisureComplex",],
			names: ["Ventry Entryport (for Zonkhana Metropolis)", "Middle Island Metropolis (city spaceport)", "Kev's Morray Rent Inc. (tourism)", "Volcano de Plasma (Visitor's Centre)",],
		}, ],
	};
	pf._locationOverrides["0 131"] =
	{
		main: [ // Zadies
			{
			roles: ["capitalCity", "capitalCity", "capitalCity", "leisureComplex", "factory",],
			names: ["Zadia (Capital city shuttleport)", "Galactic Plaza (GalCop Senate)", "Vipersville (Galactic Police HQ)", "Santaarian Arena (Visitor's Centre)", "Derrick's Duralium Depot",],
		}, ],
	};
	pf._locationOverrides["0 147"] =
	{
		main: [ // Diso
			{
			roles: ["capitalCity", "leisureComplex", "capitalCity", "leisureComplex", "factory",],
			names: ["Mahonville (Capital city shuttleport)", "Ouzan Slopes vineyards (Tourism)", "Veers Faultsville (Tourism)", "Santaarian Arena (Visitor's Centre)", "Derrick's Duralium Depot",],
		}, ],
	};
	pf._locationOverrides["0 151"] =
	{
		main: [ // Ceesxe - (Economy Research Centre works on versions of the Traders Almanach)
			{
			roles: ["capitalCity", "factory", "factory", "leisureComplex", "", "",],
			names: ["Helio city (Capital city shuttleport)", "Galtech Industries Corporation", "Pteradyne Technologies, Inc", "Economy Research Center", "", "",],
		}, ],
	};

	pf._locationOverrides["0 153"] =
	{
		main: [ // Aona - Dark Wheel places everything underwater with only volcano tips poking out! But Vanilla/Povray/Stranger’s FPO textures don’t show any of this.
			{
			roles: ["factory", "", "", "", "", "",],
			names: ["Aonatech Corporation", "", "", "", "", "",],
		}, ],
	};
		pf._locationOverrides["0 154"] =
	{
		main: [ // Isinor - there should be more landing sites if one uses a Moray! Leisure complex chosen to represent town rather than city
			{
			roles: ["leisureComplex",],
			names: ["St Standing (Capital township shuttleport)",],
		}, ],
	};
		pf._locationOverrides["0 172"] =
	{
		main: [ // Esveor
			{
			roles: ["capitalCity", "capitalCity", "capitalCity", "factory", "leisureComplex",],
			names: ["Anonbe (Capital city)", "Isincean (Capital city)", "Tiincers (Capital city)", "Peptoo-Bismol Extraction Plant", "Exveorian Hockey stadium",],
		}, ],
	};
		pf._locationOverrides["0 177"] =
	{
		main: [ // Larais - Effects: Orange haze prevents seeing anything (Mutabilis adds in lightening strikes)
			{
			roles: ["", "", "", "factory", "dump",],
			names: ["", "", "", "Genu Brewery", "Drexville dump",],
		}, ],
	};
		pf._locationOverrides["0 186"] =
	{
		main: [ // Zarece - really needs Cloud Cities to dock at
			{
			roles: ["capitalCity", "capitalCity", "capitalCity", "capitalCity", "capitalCity",],
			names: ["Braathnir (Cloud city)", "Owmrah (Cloud city)", "Zaeesove (Cloud city)", "Veanatxa (Cloud city)", "Hisbiso (Cloud city)",],
		}, ],
	};
	pf._locationOverrides["0 227"] =
	{
		main: [ // Qutiri - the third below could be changed to Cathedral if such were created
			{
			roles: ["capitalCity", "capitalCity", "feudal-planetFall2_mainSurface_FSCathedral", "capitalCity",],
			names: ["Empire of Rrowthiessa (Imperial Spaceport)", "Empire of Shrizzar (Imperial Spaceport)", "Bishopric of the Straits (Straits Seminary)", "Qitroomax port (Republic of Maar)",],
			}, ],
	};
	pf._locationOverrides["0 250"] =
	{
		main: [ // Xexedi
			{
			roles: ["capitalCity", "capitalCity", "capitalCity", "factory", "factory", "factory",],
			names: ["Xexedi Spaceport (Capital city spaceport)", "Skyneedle Hypermall (Shopping Centre)", "Oocruise Terminal (tourism)", "Zorgon Petterson Spaceyards", "L’Ooreaal Works complex", "Cassiterite mines",],
			}, ],
	};

// Galaxy 2 - Colesque

};
