"use strict";
this.name = "laserBooster_worldScript.js";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Script for laser booster";
this.version = "2.1";

this._holdDamage = {
	"FORWARD": { primary: "", secondary: "" },
	"AFT": { primary: "", secondary: "" },
	"PORT": { primary: "", secondary: "" },
	"STARBOARD": { primary: "", secondary: "" }
};
this._damagedEq = "EQ_WEAPON_LBOOST_DAMAGED_LASER";
this._notAvailable = ["EQ_WEAPON_NONE", this._damagedEq];
this._switching = false;
this._baseBreakChance = 0.002;
this._baseLaserTemp = 2;
this._normalLaserDamage = true;

this._weaponInfoLookup = {
    "EQ_WEAPON_ACHENAR_PULSE_02_LASER": {energy: 0.8, damage: 30.0},
    "EQ_WEAPON_ANDERSON_LASER": {energy: 1.4, damage: 100.0},
    "EQ_WEAPON_ASSAULT_LASER": {energy: 1.5, damage: 28.0},
    "EQ_WEAPON_BEAM_LASER": {energy: 0.5, damage: 6.0},
    "EQ_WEAPON_BEAM_LASER_2": {energy: 0.5, damage: 6.0},
    "EQ_WEAPON_BEAM_LASER_3": {energy: 0.5, damage: 6.0},
    "EQ_WEAPON_BEAM_LASER_4": {energy: 0.5, damage: 6.0},
    "EQ_WEAPON_BEAM_LASER_5": {energy: 0.5, damage: 6.0},
    "EQ_WEAPON_BLAST_LASER": {energy: 0.5, damage: 15.0},
    "EQ_WEAPON_BURST_LASER": {energy: 1.4, damage: 20.0},
    "EQ_WEAPON_CANNON_1": {energy: 10.0, damage: 100.0},
    "EQ_WEAPON_CANNON_10": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_10_2": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_10_3": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_10_4": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_10_5": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_11": {energy: 5.0, damage: 50.0},
    "EQ_WEAPON_CANNON_11_2": {energy: 5.0, damage: 50.0},
    "EQ_WEAPON_CANNON_11_3": {energy: 5.0, damage: 50.0},
    "EQ_WEAPON_CANNON_11_4": {energy: 5.0, damage: 50.0},
    "EQ_WEAPON_CANNON_11_5": {energy: 5.0, damage: 50.0},
    "EQ_WEAPON_CANNON_12": {energy: 10.0, damage: 100.0},
    "EQ_WEAPON_CANNON_12_2": {energy: 10.0, damage: 100.0},
    "EQ_WEAPON_CANNON_12_3": {energy: 10.0, damage: 100.0},
    "EQ_WEAPON_CANNON_12_4": {energy: 10.0, damage: 100.0},
    "EQ_WEAPON_CANNON_12_5": {energy: 10.0, damage: 100.0},
    "EQ_WEAPON_CANNON_13": {energy: 20.0, damage: 200.0},
    "EQ_WEAPON_CANNON_14": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_15": {energy: 15.0, damage: 300.0},
    "EQ_WEAPON_CANNON_16": {energy: -20.0, damage: 80.0},
    "EQ_WEAPON_CANNON_17": {energy: 15.0, damage: 300.0},
    "EQ_WEAPON_CANNON_18": {energy: 15.0, damage: 150.0},
    "EQ_WEAPON_CANNON_2": {energy: 10.0, damage: 60.0},
    "EQ_WEAPON_CANNON_2_2": {energy: 10.0, damage: 60.0},
    "EQ_WEAPON_CANNON_2_3": {energy: 10.0, damage: 60.0},
    "EQ_WEAPON_CANNON_2_4": {energy: 10.0, damage: 60.0},
    "EQ_WEAPON_CANNON_2_5": {energy: 10.0, damage: 60.0},
    "EQ_WEAPON_CANNON_3": {energy: 10.0, damage: 60.0},
    "EQ_WEAPON_CANNON_4": {energy: 7.0, damage: 75.0},
    "EQ_WEAPON_CANNON_4_2": {energy: 7.0, damage: 75.0},
    "EQ_WEAPON_CANNON_4_3": {energy: 7.0, damage: 75.0},
    "EQ_WEAPON_CANNON_4_4": {energy: 7.0, damage: 75.0},
    "EQ_WEAPON_CANNON_4_5": {energy: 7.0, damage: 75.0},
    "EQ_WEAPON_CANNON_5": {energy: 14.0, damage: 150.0},
    "EQ_WEAPON_CANNON_5_2": {energy: 14.0, damage: 150.0},
    "EQ_WEAPON_CANNON_5_3": {energy: 14.0, damage: 150.0},
    "EQ_WEAPON_CANNON_5_4": {energy: 14.0, damage: 150.0},
    "EQ_WEAPON_CANNON_5_5": {energy: 14.0, damage: 150.0},
    "EQ_WEAPON_CANNON_6": {energy: 5.0, damage: 100.0},
    "EQ_WEAPON_CANNON_7": {energy: 5.0, damage: 60.0},
    "EQ_WEAPON_CANNON_7_2": {energy: 5.0, damage: 60.0},
    "EQ_WEAPON_CANNON_7_3": {energy: 5.0, damage: 60.0},
    "EQ_WEAPON_CANNON_7_4": {energy: 5.0, damage: 60.0},
    "EQ_WEAPON_CANNON_7_5": {energy: 5.0, damage: 60.0},
    "EQ_WEAPON_CANNON_8": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_9": {energy: -20.0, damage: 80.0},
    "EQ_WEAPON_CANNON_EA": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_EA_2": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_EA_3": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_EA_4": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_EA_5": {energy: 0.0, damage: 40.0},
    "EQ_WEAPON_CANNON_ECO": {energy: 2.0, damage: 100.0},
    "EQ_WEAPON_CANNON_ECO_2": {energy: 2.0, damage: 100.0},
    "EQ_WEAPON_CANNON_ECO_3": {energy: 2.0, damage: 100.0},
    "EQ_WEAPON_CANNON_ECO_4": {energy: 2.0, damage: 100.0},
    "EQ_WEAPON_CANNON_ECO_5": {energy: 2.0, damage: 100.0},
    "EQ_WEAPON_CANNON_HEAVY_SAPPER": {energy: 10.0, damage: 20.0},
    "EQ_WEAPON_CANNON_HEAVY_SNIPER_GUN": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_HEAVY_SNIPER_GUN_2": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_HEAVY_SNIPER_GUN_3": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_HEAVY_SNIPER_GUN_4": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_HEAVY_SNIPER_GUN_5": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_SAPPER": {energy: 5.0, damage: 10.0},
    "EQ_WEAPON_CANNON_SNIPER_GUN": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_SNIPER_GUN_2": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_SNIPER_GUN_3": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_SNIPER_GUN_4": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_SNIPER_GUN_5": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_CANNON_THARGOID": {energy: 2.2, damage: 60.0},
    "EQ_WEAPON_DEXM_LASER": {energy: 1.0, damage: 40.0},
    "EQ_WEAPON_DUAL_LASER": {energy: 0.8, damage: 12.0},
    "EQ_WEAPON_EBEAM_LASER": {energy: 0.4, damage: 6.0},
    "EQ_WEAPON_ECO_LASER": {energy: 0.3, damage: 16.0},
    "EQ_WEAPON_ECO_LASER_2": {energy: 0.3, damage: 16.0},
    "EQ_WEAPON_ECO_LASER_3": {energy: 0.3, damage: 16.0},
    "EQ_WEAPON_ECO_LASER_4": {energy: 0.3, damage: 16.0},
    "EQ_WEAPON_ECO_LASER_5": {energy: 0.3, damage: 16.0},
    "EQ_WEAPON_ECO_REACTOR": {energy: -1.0, damage: 0.0},
    "EQ_WEAPON_ECO_REACTOR_2": {energy: -1.0, damage: 0.0},
    "EQ_WEAPON_ECO_REACTOR_3": {energy: -1.0, damage: 0.0},
    "EQ_WEAPON_ECO_REACTOR_4": {energy: -1.0, damage: 0.0},
    "EQ_WEAPON_ECO_REACTOR_5": {energy: -1.0, damage: 0.0},
    "EQ_WEAPON_ECU_BEAM_LASER": {energy: 0.5, damage: 6.0},
    "EQ_WEAPON_ECU_MILITARY_LASER": {energy: 1.1, damage: 12.0},
    "EQ_WEAPON_ECU_MINING_LASER": {energy: 1.4, damage: 50.0},
    "EQ_WEAPON_ECU_PULSE_LASER": {energy: 0.8, damage: 15.0},
    "EQ_WEAPON_EMILITARY_LASER": {energy: 1.5, damage: 12.0},
    "EQ_WEAPON_EPULSE_LASER": {energy: 0.6, damage: 13.0},
    "EQ_WEAPON_FRONTIER_LASER": {energy: 0.8, damage: 30.0},
    "EQ_WEAPON_GATLING_LASER_1": {energy: 1.0, damage: 10.0},
    "EQ_WEAPON_GATLING_LASER_2": {energy: 2.0, damage: 20.0},
    "EQ_WEAPON_GATLING_LASER_3": {energy: 3.0, damage: 30.0},
    "EQ_WEAPON_GATLING_LASER_4": {energy: 4.0, damage: 40.0},
    "EQ_WEAPON_GATLING_LASER_5": {energy: 5.0, damage: 50.0},
    "EQ_WEAPON_GATLING_LASER_COOLER": {energy: 1.0, damage: 0.0},
    "EQ_WEAPON_HIRAD_LASER": {energy: 0.9, damage: 30.0},
    "EQ_WEAPON_HVARISCAN_LASER": {energy: 0.8, damage: 18.0},
    "EQ_WEAPON_JKMINING_LASER": {energy: 1.4, damage: 100.0},
    "EQ_WEAPON_LASER_COOLER": {energy: 3.0, damage: 0.0},
    "EQ_WEAPON_LUCAS_LASER": {energy: 0.5, damage: 10.0},
    "EQ_WEAPON_MILITARY_LASER": {energy: 1.1, damage: 12.0},
    "EQ_WEAPON_MILITARY_LASER_2": {energy: 1.1, damage: 12.0},
    "EQ_WEAPON_MILITARY_LASER_3": {energy: 1.1, damage: 12.0},
    "EQ_WEAPON_MILITARY_LASER_4": {energy: 1.1, damage: 12.0},
    "EQ_WEAPON_MILITARY_LASER_5": {energy: 1.1, damage: 12.0},
    "EQ_WEAPON_MINING_LASER": {energy: 1.4, damage: 50.0},
    "EQ_WEAPON_NONE": {energy: 0.0, damage: 0.0},
    "EQ_WEAPON_PARTICLE_ACCELERATOR_LASER": {energy: 0.0, damage: 6.5},
    "EQ_WEAPON_PULSE_LASER": {energy: 0.8, damage: 15.0},
    "EQ_WEAPON_PULSE_LASER_2": {energy: 0.8, damage: 15.0},
    "EQ_WEAPON_PULSE_LASER_3": {energy: 0.8, damage: 15.0},
    "EQ_WEAPON_PULSE_LASER_4": {energy: 0.8, damage: 15.0},
    "EQ_WEAPON_PULSE_LASER_5": {energy: 0.8, damage: 15.0},
    "EQ_WEAPON_QVC_LASER": {energy: 1.4, damage: 35.0},
    "EQ_WEAPON_REV_THARGOID_LASER": {energy: 1.1, damage: 24.0},
    "EQ_WEAPON_RIMMERACE_LASER": {energy: 1.1, damage: 20.0},
    "EQ_WEAPON_STAR_LASER": {energy: 1.0, damage: 14.0},
    "EQ_WEAPON_THARGOID_LASER": {energy: 1.1, damage: 12.5},
    "EQ_WEAPON_THARGOID_PLASMA_ACCELERATOR": {energy: 100.0, damage: 437.5},
    "EQ_WEAPON_VARISCAN_LASER": {energy: 0.8, damage: 20.0},
    "EQ_WEAPON_VIMANA_BEAM": {energy: 0.5, damage: 15.0},
    "EQ_WEAPON_WILLIAMS_LASER": {energy: 0.5, damage: 25.0},
    "EQ_WEAPON_ZEUSCORP_LASER": {energy: 0.8, damage: 30.0},
	"EQ_WEAPON_ULTRA_LASER": {energy: 1.1, damage: 200.0},
};

this._trueValues = ["yes", "1", 1, "true", true];

this._lbConfig = {
    Name: this.name,
    Display: "Settings",
    Alias: "Laser Booster",
    Alive: "_lbConfig",
	Bool: {
		B0: { Name: "_normalLaserDamage", Def: true, Desc: "Non-booster damage" },
		Info: "0: Indicates whether damage can occur to lasers without the booster being in use."
	},
	SInt: {
		S0: { Name: "_baseBreakChance", Def: 0.002, Min: 0, Max: 1, Float:true, Desc: "Break chance" },
		Info: "0: The base chance that damage will occur. Will be increased by a factor related to laser temperature when booster in use; "
	},
};

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
	this.laserTemp = this._baseLaserTemp;
	missionVariables.laserBooster = "INACTIVE";
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
    if (missionVariables.LaserBooster_Data) {
        this._holdDamage = JSON.parse(missionVariables.LaserBooster_Data);
    }
    if (missionVariables.LaserBooster_BreakChance) {
        this._baseBreakChance = parseFloat(missionVariables.LaserBooster_BreakChance);
    }
    if (missionVariables.LaserBooster_NormalDamage) {
        this._normalLaserDamage = (this._trueValues.indexOf(missionVariables.LaserBooster_NormalDamage) >= 0 ? true : false);
    }
    this.$updateManifest();
    // register our settings, if Lib_Config is present
    if (worldScripts.Lib_Config) {
        worldScripts.Lib_Config._registerSet(this._lbConfig);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function() {
    missionVariables.LaserBooster_Data = JSON.stringify(this._holdDamage);
    missionVariables.LaserBooster_BreakChance = this._baseBreakChance;
    missionVariables.LaserBooster_NormalDamage = this._normalLaserDamage;
}

//-------------------------------------------------------------------------------------------------------------
this.shipLaunchedFromStation = function () {
	missionVariables.laserBooster = "INACTIVE";
	this.callCount = 0;
	this.laserTemp = this._baseLaserTemp;
	this.findLaser();
    if (!this._normalLaserDamage) {
        this._holdBreakChance = this._baseBreakChance;
        this._baseBreakChance = 0;
    }
	this.callbackID = addFrameCallback(this.checkTemp.bind(this));
}

//-------------------------------------------------------------------------------------------------------------
this.checkTemp = function () {
	this.callCount++;
	if (player.ship.laserHeatLevel > this.laserTemp && this.callCount >= 10) {
		this.callCount = 0;
		this.breakChance = this._baseBreakChance;
		if (missionVariables.laserBooster === "ACTIVE") { this.breakChance += (player.ship.laserHeatLevel / 100); }
		if (Math.random() < this.breakChance) { this.breakLaser(); }
	}
	this.laserTemp = player.ship.laserHeatLevel;
}

//-------------------------------------------------------------------------------------------------------------
this.shipAttackedOther = function (other) {
	if (player.ship.equipmentStatus("EQ_LASERBOOSTER") !== "EQUIPMENT_OK" || missionVariables.laserBooster !== "ACTIVE" || !other || other.isMainStation || !other.isValid) { return; }

	this.findLaser();
	if (player.ship.energy > 64) {
		other.energy -= this.weaponDamage;
		player.ship.energy -= this.weaponDrain;
	} else {
		player.consoleMessage("Laser booster deactivated - energy low");
		missionVariables.laserBooster = "INACTIVE";
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = this.shipDockedWithStation = this.stopCallback = function () {
	missionVariables.laserBooster = "INACTIVE";
	if (this.callbackID) { removeFrameCallback(this.callbackID); }
    this._baseBreakChance = this._holdBreakChance;
	delete this.callbackID;
}

//-------------------------------------------------------------------------------------------------------------
this.viewDirectionChanged = function (viewString) {
	this.laserTemp = this._baseLaserTemp;
	this.findLaser();
}

//-------------------------------------------------------------------------------------------------------------
this.equipmentDamaged = function (equipment) {
	if (equipment === "EQ_LASERBOOSTER") {
		missionVariables.laserBooster = "INACTIVE";
		this.stopCallback();
	}
}

//-------------------------------------------------------------------------------------------------------------
this.breakLaser = function () {
	var p = player.ship;
	player.consoleMessage("Laser failure detected!");
	var side = "";	
	switch (player.ship.viewDirection) {
		case "VIEW_FORWARD":
		case "VIEW_CUSTOM":
            this._holdDamage["FORWARD"].primary = p.forwardWeapon.equipmentKey;
            p.forwardWeapon = this._damagedEq;
			side = "EQ_FORWARD_LBOOST_REPAIRITEM";
			break;
		case "VIEW_AFT":
            this._holdDamage["AFT"].primary = p.aftWeapon.equipmentKey;
            p.aftWeapon = this._damagedEq;
			side = "EQ_AFT_LBOOST_REPAIRITEM";
			break;
		case "VIEW_PORT":
            this._holdDamage["PORT"].primary = p.portWeapon.equipmentKey;
            p.portWeapon = this._damagedEq;
			side = "EQ_PORT_LBOOST_REPAIRITEM";
			break;
		case "VIEW_STARBOARD":
			this._holdDamage["STARBOARD"].primary = p.starboardWeapon.equipmentKey;
			p.starboardWeapon = this._damagedEq;
			side = "EQ_STARBOARD_LBOOST_REPAIRITEM";
			break;
	}
	this.$playSound();
	this.$updateManifest();
	p.awardEquipment(side);
	p.setEquipmentStatus(side, "EQUIPMENT_DAMAGED");
	this.weaponDamage = 0;
	this.weaponDrain = 0;
}

//-------------------------------------------------------------------------------------------------------------
this.equipmentRepaired = function (equipment) {
    if (equipment.indexOf("LBOOST_REPAIRITEM") == -1) return;
	var p = player.ship;
    var lmss = worldScripts.LMSS_Core;
    if (lmss) lmss._switching = true;
    this._switching = true;
    // repair the item.
    switch (equipment) {
        case "EQ_FORWARD_LBOOST_REPAIRITEM":
            p.removeEquipment(equipment);
			this.callCount = 0;
			if (p.forwardWeapon.equipmentKey == this._damagedEq) {
            	p.forwardWeapon = this._holdDamage["FORWARD"].primary;
            	this._holdDamage["FORWARD"].primary = "";
			}
            break;
		case "EQ_FORWARD_SECONDARY_LBOOST_REPAIRITEM":
            p.removeEquipment(equipment);
			lmss._forwardAltKey = this._holdDamage["FORWARD"].secondary;
			this._holdDamage["FORWARD"].secondary = "";
			break;
        case "EQ_AFT_LBOOST_REPAIRITEM":
            p.removeEquipment(equipment);
			this.callCount = 0;
			if (p.aftWeapon.equipmentKey == this._damagedEq) {
            	p.aftWeapon = this._holdDamage["AFT"].primary;
            	this._holdDamage["AFT"].primary = "";
			}
            break;
		case "EQ_AFT_SECONDARY_LBOOST_REPAIRITEM":
            p.removeEquipment(equipment);
			lmss._aftAltKey = this._holdDamage["AFT"].secondary;
			this._holdDamage["AFT"].secondary = "";
			break;
        case "EQ_PORT_LBOOST_REPAIRITEM":
            p.removeEquipment(equipment);
			this.callCount = 0;
			if (p.portWeapon.equipmentKey == this._damagedEq) {
            	p.portWeapon = this._holdDamage["PORT"].primary;
            	this._holdDamage["PORT"].primary = "";
			}
            break;
		case "EQ_PORT_SECONDARY_LBOOST_REPAIRITEM":
            p.removeEquipment(equipment);
			lmss._portAltKey = this._holdDamage["PORT"].secondary;
			this._holdDamage["PORT"].secondary = "";
			break;
        case "EQ_STARBOARD_LBOOST_REPAIRITEM":
            p.removeEquipment(equipment);
			this.callCount = 0;
			if (p.starboardWeapon.equipmentKey == this._damagedEq) {
            	p.starboardWeapon = this._holdDamage["STARBOARD"].primary;
            	this._holdDamage["STARBOARD"].primary = "";
			}
            break;
		case "EQ_STARBOARD_SECONDARY_LBOOST_REPAIRITEM":
            p.removeEquipment(equipment);
			lmss._starboardAltKey = this._holdDamage["STARBOARD"].secondary;
			this._holdDamage["STARBOARD"].secondary = "";
			break;
    }
    if (lmss) {
		lmss._switching = false;
		lmss.$updateManifest();
	}
    this._switching = false;
	this.$updateManifest();
	this.findLaser();
}

//-------------------------------------------------------------------------------------------------------------
this.findLaser = function () {
	var lasertype = "NONE";
	switch (player.ship.viewDirection) {
		case "VIEW_FORWARD":
		case "VIEW_CUSTOM":
			lasertype = player.ship.forwardWeapon;
			break;
		case "VIEW_AFT":
			lasertype = player.ship.aftWeapon;
			break;
		case "VIEW_PORT":
			lasertype = player.ship.portWeapon;
			break;
		case "VIEW_STARBOARD":
			lasertype = player.ship.starboardWeapon;
			break;
	}

	var eq = this._weaponInfoLookup[lasertype];
	if (eq) {
		this.weaponDamage = eq.damage;
		this.weaponDrain = eq.energy;
	} else {
		this.weaponDamage = 0;
		this.weaponDrain = 0;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$updateManifest = function $updateManifest() {
	var list = [];
	var p = player.ship;

	list.push("Damaged Lasers:");
    var lmss = worldScripts.LMSS_Core;

	if (p.forwardWeapon.equipmentKey == this._damagedEq) {
        list.push("Forward: " + this.$getEquipmentName(this._holdDamage["FORWARD"].primary));
    }
    if (lmss && lmss._forwardAltKey == this._damagedEq) {
        list.push("Forward (secondary): " + this.$getEquipmentName(this._holdDamage["FORWARD"].secondary));
    }
	if (p.aftWeapon.equipmentKey == this._damagedEq) {
        list.push("Aft: " + this.$getEquipmentName(this._holdDamage["AFT"].primary));
	}
    if (lmss && lmss._aftAltKey == this._damagedEq) {
        list.push("Aft (secondary): " + this.$getEquipmentName(this._holdDamage["AFT"].secondary));
    }
	if (p.portWeapon.equipmentKey == this._damagedEq) {
        list.push("Port: " + this.$getEquipmentName(this._holdDamage["PORT"].primary));
	}
    if (lmss && lmss._portAltKey == this._damagedEq) {
        list.push("Port (secondary): " + this.$getEquipmentName(this._holdDamage["PORT"].secondary));
    }
	if (p.starboardWeapon.equipmentKey == this._damagedEq) {
        list.push("Starboard: " + this.$getEquipmentName(this._holdDamage["STARBOARD"].primary));
	}
    if (lmss && lmss._starboardAltKey == this._damagedEq) {
        list.push("Starboard (secondary): " + this.$getEquipmentName(this._holdDamage["STARBOARD"].secondary));
    }

	if (list.length === 1) {
		// no secondary lasers installed
		mission.setInstructions(null);
	} else {
		mission.setInstructions(list, this.name);
	}
}

//-------------------------------------------------------------------------------------------------------------
// returns the name of a particular equipment item
this.$getEquipmentName = function $getEquipmentName(equipment) {
	var laser = EquipmentInfo.infoForKey(equipment);
	if (!laser || laser.name === "Remove Laser") {
		return "--None--";
	} else {
		return laser.name;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$switchPosition = function $switchPosition(position) {
	var p = player.ship;
    var hold = this._holdDamage[position].primary;
	if (hold != "") {
		p.removeEquipment("EQ_" + position + "_LBOOST_REPAIRITEM");
		if (worldScripts.VimanaX_HUD) worldScripts.VimanaX_HUD.equipmentRepaired("EQ_" + position + "_LBOOST_REPAIRITEM");
	}
	if (this._holdDamage[position].secondary != "") {
		p.removeEquipment("EQ_" + position + "_SECONDARY_LBOOST_REPAIRITEM");
		if (worldScripts.VimanaX_HUD) worldScripts.VimanaX_HUD.equipmentRepaired("EQ_" + position + "_SECONDARY_LBOOST_REPAIRITEM");
	}
    this._holdDamage[position].primary = this._holdDamage[position].secondary;
    this._holdDamage[position].secondary = hold;
	if (this._holdDamage[position].primary != "") {
		p.awardEquipment("EQ_" + position + "_LBOOST_REPAIRITEM");
		p.setEquipmentStatus("EQ_" + position + "_LBOOST_REPAIRITEM", "EQUIPMENT_DAMAGED");
	}
	if (this._holdDamage[position].secondary != "") {
		p.awardEquipment("EQ_" + position + "_SECONDARY_LBOOST_REPAIRITEM");
		p.setEquipmentStatus("EQ_" + position + "_SECONDARY_LBOOST_REPAIRITEM", "EQUIPMENT_DAMAGED");
	}
    this.$updateManifest();
}

//-------------------------------------------------------------------------------------------------------------
this.$transferPrimaryLaser = function $transferPrimaryLaser(fromPosition, toPosition) {
	if (this._holdDamage[toPosition].primary != "") {
		p.removeEquipment("EQ_" + toPosition + "_LBOOST_REPAIRITEM");
		if (worldScripts.VimanaX_HUD) worldScripts.VimanaX_HUD.equipmentRepaired("EQ_" + toPosition + "_LBOOST_REPAIRITEM");
	}
	if (this._holdDamage[fromPosition].primary != "") {
		p.removeEquipment("EQ_" + fromPosition + "_LBOOST_REPAIRITEM");
		if (worldScripts.VimanaX_HUD) worldScripts.VimanaX_HUD.equipmentRepaired("EQ_" + fromPosition + "_SECONDARY_LBOOST_REPAIRITEM");
	}
    var hold = this._holdDamage[toPosition].primary;
    this._holdDamage[toPosition].primary = this._holdDamage[fromPosition].primary;
    this._holdDamage[fromPosition].primary = hold;
	if (this._holdDamage[toPosition].primary != "") {
		p.awardEquipment("EQ_" + toPosition + "_LBOOST_REPAIRITEM");
		p.setEquipmentStatus("EQ_" + toPosition + "_LBOOST_REPAIRITEM", "EQUIPMENT_DAMAGED");
	}
	if (this._holdDamage[fromPosition].primary != "") {
		p.awardEquipment("EQ_" + fromPosition + "_LBOOST_REPAIRITEM");
		p.setEquipmentStatus("EQ_" + fromPosition + "_LBOOST_REPAIRITEM", "EQUIPMENT_DAMAGED");
	}
    this.$updateManifest();
}

//-------------------------------------------------------------------------------------------------------------
// play the scrape damage sound effect
this.$playSound = function $playSound() {
	var mySound = new SoundSource;
    mySound.sound = "[player-scrape-damage]";
	mySound.loop = false;
	mySound.play();
}
