"use strict";
this.name           = "assassins_rebooted_victim6.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script for the 6th Mission Ship - O-Ren Ishii in a Cobra Mark IX";

this.shipSpawned = function()
{
// All Victims (except the first one) are offered as targets after the player recieves the Mark Transponder Scanner.
// Victims are marked in flashing red and blue, but you cannot use your cloak or energy bomb (if you have them) whilst you are in the same system as the victim.
// As the victims only appear at their respective system at the time their mission is running, their own script tests to see if the player has either item of equipment
// and replaces it with a dummy (which just appears adds the words '(Unavailable)' on the items F5 screen description, so that you no longer have a useable cloak or
// energy bomb. The dummy equipment is tested for under death actions and by the main script and rewards the real equipment and removes the dummy. The main script
// doesn't need to check for the presence of the victim as if he is there, his script disables the equipment when he spawns. The effect is that you can't use your cloak
// whilst you are in the victim's system and he is alive, but you get them back as soon as he dies or you leave his system.
//  Checks to see that the equipment is working. If it is damaged then it isn't removed, so you don't get a free repair
if (player.ship.equipmentStatus("EQ_CLOAKING_DEVICE") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_CLOAKING_DEVICE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK");
}
if (player.ship.equipmentStatus("EQ_ENERGY_BOMB") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ENERGY_BOMB");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB");
}
// Closing Bracket for This Ship Spawned.
}
// Only react to attacks from the player.
this.shipBeingAttacked = function (whom)
{
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
// Does not respond either to NPC attacks or accidental friendly fire from it's own side.
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1) 
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// As Victim 6 is a fugitive, police ships and bounty hunters will attack it. The attacking ship will be forced to break off however and the Victim won't respond to the attack.
// This makes Victim 6 effectively unkillable by NPCs as any NPC which hits the ships is forced to flee 26kms from it.
// As Victim 6 is fought way out of the space lane, it is very unlikley to be found by a police or hunter ship, but the code is included just in case.
else
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
return;		
}
// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
// Same Tests as for being attacked above.
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1) 
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
else
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
return;		
}
// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
// Same Tests as for being attacked above, but whilst the Victim will ignore a laser attack (as it won't be hit again), if an NPC has fired a missile at it, it will send
// a script message to the AI to flee the incoming missile and use ECM, but not to attack the other ship.
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_MISSILE"); 
return;	
}
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1) 
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
else
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.reactToAIMessage("NPC_MISSILE"); 
return;		
}
// End of this.shipAttackedWithMissile
}

this.shipDied = function (whom)
{
if (whom && whom.isPlayer)
{
missionVariables.assassins_rebooted_stage = 31;
mission.setInstructionsKey("assassins_rebooted_mission_description_23", "AssassinsRebooted");
mission.unmarkSystem(81);
this.ship.commsMessage(expandDescription("[assassins-death-victim6]"), player.ship);
// Re-Award the Cloak and / or Energy Bomb if either or both were disabled (You don't get em back if you didn't have them in the first place).
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK");
player.ship.awardEquipment("EQ_CLOAKING_DEVICE");
}
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB");
player.ship.awardEquipment("EQ_ENERGY_BOMB");
}
// End of Killed by the Player.
}



// End of this.shipDied
}
