"use strict";
this.name           = "assassins_rebooted_special_branch_orbital_base.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and make attacking it a crime. Also Spawns its associated ships nearby.";

this.shipSpawned = function()
{
// Turn the Station's dock to face the main system station.
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
// A Thargoid Invasion of Geteve takes place and at different stages of the war, different types of ships will be present around the Outpost depending on the variable.
// At 0 the invasion hasn't started yet.
// In peacetime add two wings (a leader each with two escorts) of Special Branch Asps with AIs to patrol the area around to outpost to about 20kms out.
system.addShips("assassins_rebooted_special_branch_asp_base_patrol", 2, this.ship.position, 15000);
// When the Invasion starts the Main Scripts adds thargoids to the spacelanes. Further Thargoids and Special Branch Asps are added near and approaching the Outpost.
if (missionVariables.assassins_rebooted_thargoid_invasion === 1) {
// Add a group of 12 Thargoids within 20kms of the Outpost. (There are 6 Asps on Patrol and the Outpost will launch more Asps up to its maximum of 10, so initally
// the battle will be 12 v 16, but it will take Special Branch a while to get all their birds in the air.
system.addShips("assassins_rebooted_thargoid_raider_type5", 8, this.ship.position, 20000);
// Group of Special Branch Asps to defend the outpost
system.addShips("assassins_rebooted_special_branch_base_defender", 6, this.ship.position, 30000);
// Group of Thargoids with an AI to go to the Witchpoint and attack any ships the come across are are added 35kms from the Outpost.
system.legacy_addShipsAtPrecisely("assassins_rebooted_thargoid_raider_type1", 4, "abs", this.ship.position.add(this.ship.heading.multiply(35000))) 
// Second Wave of Thargoids with an AI to go to the Outpost and attack it are added 40kms from the Outpost
system.legacy_addShipsAtPrecisely("assassins_rebooted_thargoid_raider_type5", 4, "abs", this.ship.position.add(this.ship.heading.multiply(40000))) 
// Group of Thargoids with an AI to go to the Main Station and attack it are added 50kms from the Outpost.
system.legacy_addShipsAtPrecisely("assassins_rebooted_thargoid_raider_type6", 5, "abs", this.ship.position.add(this.ship.heading.multiply(50000))) 
// Group of 3 Special Branch Asps with an AI to go to the Outpost and defend it are added 60kms from the Outpost.
system.legacy_addShipsAtPrecisely("assassins_rebooted_special_branch_base_defender", 3, "abs", this.ship.position.add(this.ship.heading.multiply(60000)))
// Group of Thargoids with an AI to go to the Main Station and attack it are added 100kms from the Outpost.
system.legacy_addShipsAtPrecisely("assassins_rebooted_thargoid_raider_type6", 5, "abs", this.ship.position.add(this.ship.heading.multiply(100000))) 
// Group of Thargoids with an AI to go to the Witchpoint and attack any ships the come across are are added 125kms from the Outpost.
system.legacy_addShipsAtPrecisely("assassins_rebooted_thargoid_raider_type1", 3, "abs", this.ship.position.add(this.ship.heading.multiply(125000))) 
// Third Wave of Thargoids with an AI to go to the Outpost and attack it are added 125kms from the Outpost
system.legacy_addShipsAtPrecisely("assassins_rebooted_thargoid_raider_type5", 3, "abs", this.ship.position.add(this.ship.heading.multiply(150000))) 
// Group of 3 Special Branch Asps with an AI to go to the Outpost and defend it are added 200kms from the Outpost.
system.legacy_addShipsAtPrecisely("assassins_rebooted_special_branch_base_defender", 3, "abs", this.ship.position.add(this.ship.heading.multiply(200000)))
// Group of Thargoids with an AI to go to the Main Station and attack it are added 250kms from the Outpost.
system.legacy_addShipsAtPrecisely("assassins_rebooted_thargoid_raider_type6", 5, "abs", this.ship.position.add(this.ship.heading.multiply(250000))) 
// Group of Thargoids with an AI to go to the Main Station and attack it are added 280kms from the Outpost.
system.legacy_addShipsAtPrecisely("assassins_rebooted_thargoid_raider_type6", 5, "abs", this.ship.position.add(this.ship.heading.multiply(280000))) 
// Closing Bracket for Invasion Variable at 1.
}
// Add addition ships for the Battle Bot Phase.

// At the time of the mission, the 4th Victim - Inspector Thorstan in a well equipped Special Branch Asp with two Asp Wingmen - is added near to the Outpost.
if (missionVariables.assassins_rebooted_stage === 20) {
system.addShips("assassins_rebooted_victim4",1,this.ship.position.add([1000,0,0]),8560)[0];
}
delete this.shipSpawned; 
}

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipAttackedWithMissile
}
