"use strict";
this.name		= "assassins_rebooted_repair_facility_docking.js";
this.author		= "Montana05 - Modified by LittleBear";
this.description	= "Event handler for the Nephthys Space Station Dock";
this.version		= "1.02";
this.copyright		= "2022 Montana05";
this.licence		= "CC BY-NC-SA 4.0";

// The version used in Assassins will not grant access to the player (as in plot the Repair Facility only allows its own - NPC - Customers to dock).
// This version of the script will always refuse docking permission to the player regardless of how many credits the player has.
// It will grant NPCs docking permission to dock and launch it's own private craft.

// default, while defined in the shipdata.plist another specify is needed here
this.ship.allowsDocking = false;
this.ship.disallowedDockingCollides = true;

this.acceptDockingRequestFrom = function(ship)
{
if(ship.isPlayer)
{
this.ship.allowsDocking = false;
this.ship.disallowedDockingCollides = true;
return false;
}
else
{
this.ship.allowsDocking = true;
this.ship.disallowedDockingCollides = false;
return true;		
};
};
