"use strict";
this.name		= "assassins_rebooted_repair_defender.js";
this.author		= "Montana05 - Modiified by LittleBear";
this.description	= "Event handler for the Phantom Mark I (Nephthys Space Station)";
this.version		= "1.02";
this.copyright		= "2022 Montana05";
this.licence		= "CC BY-NC-SA 4.0";

// Identical to Montana's original but also adds the code below to make the player a fugitive for attacking this version of the ship and preventing friendly fire.
this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.bounty = 0;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.bounty = 0;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.bounty = 0;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of this.shipAttackedWithMissile
}
this.shipDied = function (whom)
{
if (whom && whom.isPlayer)
{
player.bounty |= 51;
}
// End of this.shipDied
}
// End of Modification.

this.shipSpawned = function(ship)
{
	// makes sure that loaded missiles and subents are ident
	if(this.ship.missiles.length != (this.ship.subEntities.length - 2))
	{
		this.$checkMissile();
	};
};

this.shipWillLaunchFromStation = function(station)
{
    // checks if any missiles were added while docking
	if(this.ship.missiles.length != (this.ship.subEntities.length - 2))
	{
		this.$checkMissile();
	};
};

this.shipScoopedOther = function(whom)
{
    // checks if any OXP awarded a missile in flight
	if(this.ship.missiles.length != (this.ship.subEntities.length - 2))
	{
		this.$checkMissile();
	};
};

this.shipFiredMissile = function(missile, target)
{
	// removes subents for fired missiles
	this.$checkMissile();
};

// this.equipmentAdded will not be triggered if this.ship.awardEquipment is used, a workaround is needed
this.$checkMissile = function()
{
	var shipMmissile = this.$findSubEntity("nephthys_phantom_mark_I_missile");
		
	if(this.ship.missiles.length > (this.ship.subEntities.length - 2))
	{
		this.ship.restoreSubEntities();
	};
	
	while((this.ship.subEntities.length - 2) > this.ship.missiles.length)
	{
		shipMmissile.remove();
	};
};

this.$findSubEntity = function(key)
{
	for(var i = this.ship.subEntities.length - 1 ; i >=0 ; --i)
	{
		if (this.ship.subEntities[i].dataKey == key)
		{
			return this.ship.subEntities[i];
		};
	};
	return null; // couldn't find it.
};
