"use strict";
this.name           = "assassins_rebooted_red_wing.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and make attacking it a crime. Also spawns associated ships and mission ships.";

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
var pos = this.ship.position;
// Add an asteroid field around the Prison.
system.addShips("assassins_rebooted_miner_rock",45,pos,25000);
// At the start of the OXZ to dictatorship is a member of GalCop so its's ships are the official police and have police scan class
if (missionVariables.assassins_rebooted_civil_war < 2) {
// Add a Group of 3 Censor patrol ships with an AI to patrol around the prison.
system.addShips("assassins_rebooted_local_patrol_censor_leader",1,pos,10000); 
// Add a Group of 3 Enforcer patrol ships with an AI to patrol around the prison.
system.addShips("assassins_rebooted_local_patrol_enforcer_leader",1,pos,15000);
// Add a Prison Ship with 2 Quaestor escorts. Its AI will patrol near the Prison until the player arrives and then will dock with the prison to unload its prisoners.
system.addShips("assassins_rebooted_local_prison_ship_docking",1,pos,20000)
// Add a Prison Ship with 2 Enforcer escorts with an AI to travel to the main station and dock with it.
system.legacy_addShipsAtPrecisely("assassins_rebooted_planet_prison_ship", 1, "abs", this.ship.position.add(this.ship.heading.multiply(35000)))
}
// When Civil War breaks out, add groups of rebel ships with AIs to go to the prison and attack the imperial ships there.
if (missionVariables.assassins_rebooted_deamons === "Lawful") {
// Add 4 rebels in weak ships armed with pulse lasers to attack the imperial ships at the prison.
system.addShips("assassins_rebooted_weak_outlaw_rebel",4,pos,5000);
// Better equipped rebels flying Sonoran fighters  (Group of 3 - Leader and 2 Wingmen) with an AI to fly to the prison and attack imperial ships are added 10kms out. 
system.legacy_addShipsAtPrecisely("assassins_rebooted_rebel_outlaw_sonoran_type1", 1, "abs", this.ship.position.add(this.ship.heading.multiply(10000)))
// A second group is added near the Prison Ship's position. They will probabley win and any surviving rebles will go to the prison.
system.legacy_addShipsAtPrecisely("assassins_rebooted_rebel_outlaw_sonoran_type1", 1, "abs", this.ship.position.add(this.ship.heading.multiply(40000)))
// The Rebles recieve reinforcements after the 14th News Broadcast is seen.
if (missionVariables.assassins_rebooted_stage > 49) {
system.legacy_addShipsAtPrecisely("assassins_rebooted_rebel_outlaw_sonoran_type1", 1, "abs", this.ship.position.add(this.ship.heading.multiply(13000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_rebel_outlaw_sonoran_type1", 1, "abs", this.ship.position.add(this.ship.heading.multiply(18000)))
}
}
delete this.shipSpawned; 
}

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipAttackedWithMissile
}
