"use strict";

this.name = "dictatorsAmbienceAttacker-AI";

this.aiStarted = function() {
	var ai = new worldScripts["oolite-libPriorityAI"].PriorityAIController(this.ship);
	ai.setWaypointGenerator(ai.waypointsSpacelanePatrol);
	ai.setPriorities([
		//hurt them plenty, fight them till the bitter end
		{ 
			condition: ai.conditionInCombat,
			configuration: ai.configurationAcquireCombatTarget,
			behaviour: ai.behaviourDestroyCurrentTarget,
			reconsider: 5
		},
		{
			preconfiguration: ai.configurationCheckScanner,
			condition: function() {
				function $findAmbienceTarget(entity) {
					return entity.$dictatorsAmbience;
				}
				var targets = system.filteredEntities(this, $findAmbienceTarget, ship, 25600);
				if (targets.length > 0) {
					ai.setParameter("oolite_scanResultSpecific", targets[0]);
					return true;
				}
				return false;
			},
			behaviour: function() {
                if (system.info.economy < 4) {
                    ship.commsMessage("[ambienceImperialWarning]");
                } else {
                    ship.commsMessage("[ambienceJuntaWarning]");
                }
				ai.configurationAcquireScannedTarget();
				ai.behaviourDestroyCurrentTarget();
			},
			reconsider: 20
		},
		//patrol the lanes
		{
			condition: ai.conditionHasWaypoint,
			configuration: ai.configurationSetDestinationToWaypoint,
			behaviour: ai.behaviourApproachDestination,
			reconsider: 30
		},
		{
			configuration: ai.configurationSetWaypoint,
			behaviour: ai.behaviourApproachDestination,
			reconsider: 30
		}
	]);
}
