"use strict";
this.name = "GalCopBB_CargoStopper";
this.author = "phkb";
this.copyright = "2018 phkb";
this.description = "Equipment that can slow down cargo that is running away.";
this.license = "CC BY-NC-SA 4.0";

this._cargoList = [];
this._resetTimer = null;
this._cargoToCheck = null;
this._checkTimer = null;
this._ready = false;

//-------------------------------------------------------------------------------------------------------------
this.playerBoughtEquipment = function (equipmentKey) {
    if (equipmentKey === "EQ_GCM_CARGO_STOPPER_REMOVE") {
        player.ship.removeEquipment(equipmentKey);
        player.ship.removeEquipment("EQ_GCM_CARGO_STOPPER");
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipTargetAcquired = function (cargo) {
    if (this._ready === false) return;
    if (cargo.isCargo && cargo.hasRole("escape-capsule") === false && this._cargoList.indexOf(cargo) === -1 && (cargo.velocity && cargo.velocity.magnitude() > 0)) {
        this._cargoToCheck = cargo;
        if (!this._checkTimer || this._checkTimer.isRunning == false)
            this._checkTimer = new Timer(this, this.$checkCargo, 0.25, 0.25);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipLaunchedFromStation = function (station) {
    this._ready = false;
    var p = player.ship;
    if (p.hasEquipmentProviding("EQ_CARGO_SCOOPS") === true && p.equipmentStatus("EQ_GCM_CARGO_STOPPER") == "EQUIPMENT_OK") {
        this._ready = true;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.equipmentDamaged = function (equipmentKey) {
    if (equipmentKey == "EQ_FUEL_SCOOPS" || equipmentKey == "EQ_GCM_CARGO_STOPPER") this._ready = false;
}

//-------------------------------------------------------------------------------------------------------------
this.equipmentRepaired = function (equipmentKey) {
    var p = player.ship;
    if (p.hasEquipmentProviding("EQ_CARGO_SCOOPS") === true && p.equipmentStatus("EQ_GCM_CARGO_STOPPER") == "EQUIPMENT_OK") {
        this._ready = true;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipDockedAtStation = this.shipWillExitWitchspace = this.shipDied = function () {
    if (this._checkTimer && this._checkTimer.isRunning) {
        this._checkTimer.stop();
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$checkCargo = function $checkCargo() {
    var cargo = this._cargoToCheck;
    if (!cargo.isValid || !cargo.isInSpace || player.ship.target != cargo) {
        this._checkTimer.stop();
        this._cargoToCheck = null;
        return;
    }
    // check position
    var p = player.ship;
    var eq = EquipmentInfo.infoForKey("EQ_GCM_CARGO_STOPPER");
    if (p.position.distanceTo(cargo) < (p.scannerRange * eq.scriptInfo.tractor_range_factor)) {
        var deviation = p.vectorForward.angleTo(cargo.position.subtract(p.position));
        if (deviation < 0.2) {
            this.$playSound("on");
            player.consoleMessage(expandDescription("[gcm_activate_tractorbeam]"), 3);
            cargo.maxThrust = eq.scriptInfo.tractor_apply_thrust;
            cargo.thrust = eq.scriptInfo.tractor_apply_thrust;
            this._cargoList.push(cargo);
            this._checkTimer.stop();
            if (this._resetTimer == null || this._resetTimer.isRunning === false) {
                this._resetTimer = new Timer(this, this.$resetCargo, 2, 2);
            }
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
/*this.mode = function () {

}

//-------------------------------------------------------------------------------------------------------------
this.activated = function () {
    var p = player.ship;
    if (p.hasEquipmentProviding("EQ_CARGO_SCOOPS") === false) {
        player.consoleMessage("Tractor-beam offline - unable to start", 5);
        return;
    }
    var cs = worldScripts.GalCopBB_CargoStopper;
    var ships = p.checkScanner(false);
    var msg = false;
    if (ships) {
        for (var i = 0; i < ships.length; i++) {
            var cargo = ships[i];
            if (cargo.isCargo && cargo.hasRole("escape-capsule") === false && cs._cargoList.indexOf(cargo) === -1) {
                // check position
                var eq = EquipmentInfo.infoForKey("EQ_GCM_CARGO_STOPPER");
                if (p.position.distanceTo(cargo) < (p.scannerRange * eq.scriptInfo.tractor_range_factor)) {
                    var deviation = p.vectorForward.angleTo(cargo.position.subtract(p.position));
                    if (deviation < 0.2) {
                        // it's in scope 
                        if (msg === false) {
                            msg = true;
                            this.$playSound("on");
                            player.consoleMessage("Activating tractor beam", 3);
                        }
                        cargo.maxThrust = eq.scriptInfo.tractor_apply_thrust;
                        cargo.thrust = eq.scriptInfo.tractor_apply_thrust;
                        cs._cargoList.push(cargo);
                        if (cs._resetTimer == null || cs._resetTimer.isRunning === false) {
                            cs._resetTimer = new Timer(cs, cs.$resetCargo, 2, 2);
                        }
                    }
                }
            }
        }
    }
    if (msg === false) {
        player.consoleMessage("No cargo in range of tractor beam", 5);
    }
}*/

//-------------------------------------------------------------------------------------------------------------
this.$resetCargo = function $resetCargo() {
    if (this._cargoList.length === 0) {
        this._resetTimer.stop();
        this._resetTimer = null;
        return;
    }
    for (var i = this._cargoList.length - 1; i >= 0; i--) {
        var cargo = this._cargoList[i];
        if (!cargo.velocity || cargo.velocity.magnitude() <= 5) {
            if (cargo.isValid && cargo.isInSpace) {
                cargo.desiredSpeed = 0;
                cargo.performStop();
            }
            this._cargoList.splice(i, 1);
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
// play the buy/sell sound effects
this.$playSound = function $playSound(soundtype) {
    var mySound = new SoundSource;
    switch (soundtype) {
        case "on":
            mySound.sound = "tractor-beam.ogg";
            break;
    }
    mySound.loop = false;
    mySound.play();
}
