"use strict";
this.name = "GalCopBB_AsteroidFields";
this.author = "phkb";
this.copyright = "2017 phkb";
this.description = "Looks after the spawning, and subsequent re-creation, of asteroid fields";
this.license = "CC BY-NC-SA 4.0";

// array of dictionaries, containing
//      systemID        system ID where asteroid field is found
//      factor
//      seed
//      locationType
this._asteroids = [];
this._currentSystem = []; // list of asteroid field positions created in the current system
this._populateComplete = false;

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
    if (missionVariables.GalCopBBMissions_AsteroidFields) {
        this._asteroids = JSON.parse(missionVariables.GalCopBBMissions_AsteroidFields);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function () {
    missionVariables.GalCopBBMissions_AsteroidFields = JSON.stringify(this._asteroids);
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillEnterWitchspace = function (cause, destination) {
    this._currentSystem.length = 0;
    if (cause === "galactic jump") this._asteroids.length = 0;
    this._populateComplete = false;
}

//-------------------------------------------------------------------------------------------------------------
// scripts that will need an asteroid field should manually call this function from their own "systemWillPopulate" function.
// this ensures any asteroid fields will be created before they need to use them
this.systemWillPopulate = function () {
    // make sure we don't run this twice
    if (this._populateComplete === true) return;
    this.$fixAsteroidData();
    // theoretically there will only be 1 field per system, but just in case that changes, we'll store everything in an array
    var a = this._asteroids;
    for (var i = 0; i < a.length; i++) {
        if (a[i].systemID === system.ID) {
            var position = Vector3D(a[i].x, a[i].y, a[i].z).fromCoordinateSystem(a[i].coordSystem)
            //var info = worldScripts.GalCopBB_Missions.$getRandomPosition(a[i].locationType, a[i].factor, a[i].seed);
            // add an asteroid field
            system.setPopulator("gcm-asteroids-" + i, {
                callback: function (pos) {
                    system.addShips("asteroid", 60, pos, 40E3);
                }.bind(this),
                location: "COORDINATES",
                coordinates: position
            });

            this._currentSystem.push({ pos: position, locationType: a[i].locationType });
        }
    }
    this._populateComplete = true;
}

//-------------------------------------------------------------------------------------------------------------
// asteroid fields are added with factor and seed values
// once they are actually spawned, though, they will instead have x,y,z values to keep the field in roughly the same place
this.$addAsteroidField = function $addAsteroidField(sysID, factor, seed, locationType) {
    this._asteroids.push({
        systemID: sysID,
        factor: factor,
        seed: seed,
        locationType: locationType
    });
}

//-------------------------------------------------------------------------------------------------------------
this.$addAsteroidFieldDirect = function $addAsteroidFieldDirect(sysID, x, y, z, coord, locationType) {
    this._asteroids.push({
        systemID: sysID,
        x: x,
        y: y,
        z: z,
        coordSystem: coord,
        locationType: locationType
    });
}

//-------------------------------------------------------------------------------------------------------------
this.$systemHasAsteroidField = function $systemHasAsteroidField(sysID, locationType) {
    for (var i = 0; i < this._asteroids.length; i++) {
        if (this._asteroids[i].systemID === sysID && (!locationType || this._asteroids[i].locationType === locationType)) return this._asteroids[i];
    }
    return null;
}

//-------------------------------------------------------------------------------------------------------------
this.$getSystemAsteroidField = function $getSystemAsteroidField(locationType) {
    if (this._currentSystem.length === 0) return null;
    for (var i = 0; i < this._currentSystem.length; i++) {
        if (this._currentSystem[i].locationType == locationType) return this._currentSystem[i].pos;
    }
    return null;
}

//-------------------------------------------------------------------------------------------------------------
this.$fixAsteroidData = function $fixAsteroidData() {
    var gcm = worldScripts.GalCopBB_Missions;
    var a = this._asteroids;
    for (var i = 0; i < a.length; i++) {
        if (a[i].systemID === system.ID && a[i].hasOwnProperty("factor") === true) {
            var info = gcm.$getRandomPosition(a[i].locationType, a[i].factor, a[i].seed);
            a[i].x = info.x;
            a[i].y = info.y;
            a[i].z = info.z;
            a[i].coordSystem = info.coordSystem;
            delete a[i].factor;
            delete a[i].seed;
        }
    }
}