"use strict";
/*

cataclysm-thargoid-hive-2.js

Ship script for thargoid hive (second clone).


Oolite
Copyright © 2008 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/


this.name = "cataclysm-thargoid-hive-2";
this.author = "Commander McLane";
this.copyright = "© 2009 Commander McLane";
this.version = "1.1";


this.startCountdown = function () {
	player.consoleMessage(expandDescription("[cataclysm_bad_energy]"), 3);
	this.time = 15;
	this.countdownTimer = new Timer(this, this.countDown, 1, 1);
}

this.countDown = function () {
	if (this.time < 0) {
		this.countdownTimer.stop();
		//system.legacy_addShipsAtPrecisely("cataclysm_explosive_alloy", 1, "abs", this.ship.position);
		system.addShips("cataclysm_explosive_alloy", 1, this.ship.position);
		return;
	}
	player.consoleMessage(expandDescription("[cataclysm_hive_unstable]", { time: this.time }), 1);
	this.time--;
}

this.shipAttackedWithMissile = function (missile, whom) {
	missile.explode();
}

this.shipDied = function () {
	this.ship.reactToAIMessage("DEAL_ENERGY_DAMAGE");
	missionVariables.cataclysm_hivemission = "HIVE_DESTROYED";
}