"use strict";
/*

cataclysm-thargoid-hive-1.js

Ship script for thargoid hive (first clone).


Oolite
Copyright © 2008 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/


this.name = "cataclysm-thargoid-hive-1";
this.author = "Commander McLane";
this.copyright = "© 2009 Commander McLane";
this.version = "1.1";


this.startScan = function () {
	player.consoleMessage(expandDescription("[cataclysm_scan_started]"), 1);
	this.time = 15;
	this.scanTimer = new Timer(this, this.informPlayer, 1, 1);
}

this.informPlayer = function () {
	if (this.time < 0) {
		player.consoleMessage(expandDescription("[cataclysm_scan_complete]"));
		this.scanTimer.stop();
		missionVariables.cataclysm_hivemission = "SCANNED";
		player.consoleMessage(expandDescription("[cataclysm_report_onrace]"));
		mission.setInstructionsKey("cataclysm_report_scan_findings", expandDescription("[cataclysm_title]"));
		return;
	}
	player.consoleMessage(expandDescription("[cataclysm_scan_countdown]", {time:this.time}), 1);
	this.time--;
}