"use strict";
/*

cataclysm-populator.js

Script for populating systems.


Oolite
Copyright © 2008 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/


this.name = "cataclysm-populator";
this.author = "phkb";
this.copyright = "© 2023 phkb";
this.version = "1.0";

this.startUp = function() {
    if (worldScripts["Tionisla Reporter"]) {
        var tr = worldScripts["Tionisla Reporter"];
        tr.$erehwon_systemWillPopulate_hold = tr.$erehwon_systemWillPopulate;
        tr.$erehwon_systemWillPopulate = this.$tr_systemWillPopulate;
    }
}

// if tionisla reporter wins the populator function race, it needs to run the cataclysm one
// which will also run the TR one.
this.$tr_systemWillPopulate = function() {
    worldScripts["cataclysm-populator"].$interstellarPopulator_hive4();
}

this.$addHive2Ships = function () {
    system.sendAllShipsAway();
    system.addShips("cataclysm_thargoid_hive_2", 1, Vector3D(0, 0, 300000).fromCoordinateSystem("wpm"));
    system.addShips("thargoid", 10, Vector3D(0, 0, 30000).fromCoordinateSystem("wpm"), 50000);
    system.addShips("thargoid", 10, Vector3D(0, 0, 100000).fromCoordinateSystem("wpm"), 50000);
    system.addShips("thargoid", 10, Vector3D(0, 0, 170000).fromCoordinateSystem("wpm"), 50000);
    system.addShips("thargoid", 10, Vector3D(0, 0, 240000).fromCoordinateSystem("wpm"), 50000);
    system.addShips("police", 8, Vector3D(0, 0, 20000).fromCoordinateSystem("wpm"), 30000);
    system.addShips("military-ship", 6, Vector3D(0, 0, 60000).fromCoordinateSystem("wpm"), 30000);
    // in case the behemoths OXP is installed
    var beh = system.addShips("behemoth", 1, Vector3D(0, 0, 60000).fromCoordinateSystem("wpm"), 30000);    
}

this.$interstellarPopulator_hive0 = function () {
    if (missionVariables.cataclysm_hivemission == "DESTROY_HIVE" && missionVariables.cataclysm_hive_location == 0) {
        this.$addHive2Ships();
    }
}

this.$interstellarPopulator_hive1 = function () {
    if (missionVariables.cataclysm_hivemission == "DESTROY_HIVE" && missionVariables.cataclysm_hive_location == 1) {
        this.$addHive2Ships();
    }
}

this.$interstellarPopulator_hive2 = function () {
    if (missionVariables.cataclysm_hivemission == "DESTROY_HIVE" && missionVariables.cataclysm_hive_location == 2) {
        this.$addHive2Ships();
    }
}

this.$interstellarPopulator_hive3 = function () {
    if (missionVariables.cataclysm_hivemission == "DESTROY_HIVE" && missionVariables.cataclysm_hive_location == 3) {
        this.$addHive2Ships();
    }
}

this.$interstellarPopulator_hive4 = function () {
    if (galaxyNumber == 0) {
        // if cataclysm won the populator function race, make sure it runs the Tionisla Reporter function as well
        if (worldScripts["Tionisla Reporter"]) {
            var tr = worldScripts["Tionisla Reporter"];
            tr.$erehwon_systemWillPopulate_hold();
        }
    }
    if (missionVariables.cataclysm_hivemission == "DESTROY_HIVE" && missionVariables.cataclysm_hive_location == 4) {
        this.$addHive2Ships();
    }
}

this.$interstellarPopulator_hive5 = function () {
    if (missionVariables.cataclysm_hivemission == "DESTROY_HIVE" && missionVariables.cataclysm_hive_location == 5) {
        this.$addHive2Ships();
    }
}

this.$interstellarPopulator_hive6 = function () {
    if (missionVariables.cataclysm_hivemission == "DESTROY_HIVE" && missionVariables.cataclysm_hive_location == 6) {
        this.$addHive2Ships();
    }
}

this.$interstellarPopulator_investigate = function () {
    if (missionVariables.cataclysm_hivemission == "INVESTIGATE") {
        system.sendAllShipsAway();
        system.addShips("cataclysm_thargoid_hive_1", 1, Vector3D(0, 0, 300000).fromCoordinateSystem("wpm"));
        system.addShips("thargoid", 5, Vector3D(0, 0, 30000).fromCoordinateSystem("wpm"), 50000);
        system.addShips("thargoid", 5, Vector3D(0, 0, 100000).fromCoordinateSystem("wpm"), 50000);
        system.addShips("thargoid", 5, Vector3D(0, 0, 170000).fromCoordinateSystem("wpm"), 50000);
        system.addShips("thargoid", 5, Vector3D(0, 0, 240000).fromCoordinateSystem("wpm"), 50000);

        /*"addShipsAtPrecisely: cataclysm_thargoid_hive_1 1 wpm 0 0 300000", 
        "addShipsWithinRadius: thargoid 5 wpm 0 0 30000 50000", 
        "addShipsWithinRadius: thargoid 5 wpm 0 0 100000 50000", 
        "addShipsWithinRadius: thargoid 5 wpm 0 0 170000 50000", 
        "addShipsWithinRadius: thargoid 5 wpm 0 0 240000 50000"*/
    }
    if (missionVariables.cataclysm_hivemission == "DESTROY_HIVE") {
        this.$addHive2Ships();
    }
}