"use strict";
this.name        = "sfep_stations";
this.description = "stations for sfep";

this.startUp = function() {
  var ws = worldScripts["stations_for_extra_planets"];

  //stations from Griff's & CaptKev's Dodo Stations OXP
  ws.$addStations([[], ["sfep_kev1", "sfep_kev2", "sfep_kev3"], []]);

  //stations from P.A. Groove Stations OXP
  ws.$addStations([["sfep_pag_coriolis1", "sfep_pag_coriolis2", "sfep_pag_coriolis3", "sfep_pag_coriolis4", "sfep_pag_coriolis5", "sfep_pag_coriolis6"], ["sfep_pag_dodecahedron1", "sfep_pag_dodecahedron2", "sfep_pag_dodecahedron3", "sfep_pag_dodecahedron4"], ["sfep_pag_icosahedron1", "sfep_pag_icosahedron2", "sfep_pag_icosahedron3", "sfep_pag_icosahedron4"]]);

  //stations from Smivs' Accessories OXP
  ws.$addStations([["sfep_smivs_coriolis"],["sfep_smivs_dodo"],["sfep_smivs_ico"]]);

  //stations from Dertien's ZGrOovy Griff System Stations OXP
  ws.$addStations([["sfep_l", "sfep_m", "sfep_s"], ["sfep_xl"], ["sfep_xxl"]]);

  //stations from Simon B's Neolite Ships OXP
  ws.$addStations([["sfep_neolite_coriolis"], ["sfep_neolite_dodo"], []]);

  //stations from DeepSpace's and CaptSolo's DeepSpace Ships OXP
  ws.$addStations([["sfep_deepspace_coriolis"], ["sfep_deepspace_dodo"], ["sfep_deepspace_ico"]]);

  //stations from Murgh's Globe Stations OXP
  ws.$addStations([[], [], ["sfep_globestation", "sfep_globestationxl"]]);

  //stations from Murgh's Torus Stations OXP
  ws.$addStations([[], [], ["sfep_toriA", "sfep_toriB"]]);

  //station from Griff's Trade Outpost OXP
  ws.$addStations([["sfep_trade_outpost"], [], []]);

  //station from Zieman's Habitat OXP
  ws.$addStations([[], [], ["sfep_habmk2"]]);

  //station from CaptBeatnik's Rideri OXP
  ws.$addStations([[], [], ["sfep_sodalite"]]);

  //stations from Dertien's Z-GrOovY Small System Stations OXP
  ws.$addStations([["sfep_gz2_tetrahedron", "sfep_gz2_octahedron"], [], []]);

  //init spottedStations array to be used with shiplibrary
  if (!missionVariables.sfepStations) {
    this.$spottedStations = new Array();
  }
  else {
    this.$spottedStations = JSON.parse(missionVariables.sfepStations);
  }
}

this.playerWillSaveGame = function () {
	missionVariables.sfepStations = JSON.stringify(this.$spottedStations);
}

//add visited sfep_station to spottedStations array.
this.shipDockedWithStation = function(station) {
  if (station.hasRole("sfep_station")) {
    var dataKey = station.dataKey;
    if (this.$spottedStations.indexOf(dataKey) === -1) {
      this.$spottedStations.push(dataKey);
    }
  }
}
