"use strict";
this.name = "LMSS_Activator";
this.author = "phkb";
this.copyright = "2015 phkb";
this.description = "Switches the laser mount inflight between two lasers.";
this.licence = "CC BY-NC-SA 4.0";

//======================================================================================================================
this.activated = function () {

	var p = player.ship;
	var w = worldScripts.LMSS_Core;
	var check = false;

	switch (p.viewDirection) {
		case "VIEW_FORWARD":
			check = w.$hasForwardLMSS();
			if (check === true && (!w._forwardTimer || w._forwardTimer.isRunning === false)) {
				w.$switchForward();
			} else {
				if (check === false) this.$playAlertSound();
			}
			break;
		case "VIEW_AFT":
			check = w.$hasAftLMSS();
			if (check === true && (!w._aftTimer || w._aftTimer.isRunning === false)) {
				w.$switchAft();
			} else {
				if (check === false) this.$playAlertSound();
			}
			break;
		case "VIEW_PORT":
			check = w.$hasPortLMSS();
			if (check === true && (!w._portTimer || w._portTimer.isRunning === false)) {
				w.$switchPort();
			} else {
				if (check === false) this.$playAlertSound();
			}
			break;
		case "VIEW_STARBOARD":
			check = w.$hasStarboardLMSS();
			if (check === true && (!w._starboardTimer || w._starboardTimer.isRunning === false)) {
				w.$switchStarboard();
			} else {
				if (check === false) this.$playAlertSound();
			}
			break;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$playAlertSound = function $playAlertSound() {
	var mySound = new SoundSource;
	mySound.sound = "[@boop]";
	mySound.loop = false;
	mySound.play();
	player.consoleMessage(expandDescription("[lmss_unable_to_start]"));
}
