
this.name = 'Stashes';
this.copyright = '(C) 2015 Popsch.';
this.licence = 'CC-NC-by-SA 2.0';

this.debugProximityTrap = 0;

'use strict';

this.debug = false;

/** Distance at which a warning message gets triggered */
this.proximityWarning = 23000;

/** Distance at which the alarm gets triggered */
this.proximityAlert = 15010;

/** Likelyhood of police trap present */
this.TrapLikelihood = 0.02;
//this.TrapLikelihood = 1;

this.trapPosition;

this.TRAP_SPRUNG = 0;
this.TRAP_ACTIVE = 1;

this.trapState = TRAP_ACTIVE;

this.trapType = 0;

this.buoy = null;

this.$sendMilitaryWarning = function () {
    this.buoy.commsMessage(expandMissionText("stashes_military_warning"), player.ship);
};

this.$sendNormalWarning = function () {
    this.buoy.commsMessage(expandMissionText("stashes_normal_warning"), player.ship);
};

this.$respondAlertMilitary = function () {
    player.bounty += 100;

    var s = system.addShips('police', 3, player.ship.position, 10000);
    s.forEach(function (entry) {
        entry.target = player.ship;
        entry.performAttack();
    });
    s[0].commsMessage(expandMissionText("stashes_spy_alert"), player.ship);
};

this.$respondAlertRaiders = function () {
    var s = system.addShips('pirate', 4, player.ship.position, 10000);
    s.forEach(function (entry) {
        entry.target = player.ship;
        entry.performAttack();
    });
    s[0].commsMessage(expandMissionText("stashes_raider_alert"), s[1]);
};

this.$respondAlertPolice = function () {
    player.bounty += 25;

    var s = system.addShips('police', 1, player.ship.position, 10000);
    s.forEach(function (entry) {
        entry.target = player.ship;
        entry.performAttack();
    });
    s[0].commsMessage(expandMissionText("stashes_police_alert"), player.ship);
};

this.$respondAlertMerchant = function () {
    this.buoy.commsMessage(expandMissionText("stashes_trader_alert"), player.ship);
    for (var i = 0; i < 2; i++) {
        var adder = system.addShips('[adder]', 1, this.buoy.position, 100)[0];
        adder.target = player.ship;
        adder.awardEquipment('EQ_HARDENED_MISSILE');
        adder.fireMissile();
        adder.remove();
    }
    // keep the trap active
    this.trapState = TRAP_ACTIVE;
    this.distanceChecker = new Timer(this, this.$checkDistance, 4);
};

this.$respondAlertAbandoned = function () {
    this.buoy.commsMessage(expandMissionText("stashes_trader_alert"), player.ship);
};

this.$respondAlertMalfunction = function () {
    this.buoy.commsMessage(expandMissionText("stashes_faulty_alert"), player.ship);
};

this.TRAPS = [
    //prob, min-pods, max-pods, warning callback, alert callback
    0.05, 4, 7, this.$sendMilitaryWarning, this.$respondAlertMilitary,
    0.20, 3, 7, this.$sendNormalWarning, this.$respondAlertRaiders,
    0.30, 3, 4, this.$sendNormalWarning, this.$respondAlertPolice,
    0.70, 3, 7, this.$sendNormalWarning, this.$respondAlertMerchant,
    0.85, 0, 0, this.$sendNormalWarning, this.$respondAlertAbandoned,
    1.00, 3, 7, this.$sendNormalWarning, this.$respondAlertMalfunction
];


/** launch from station for testing */
this.shipWillLaunchFromStation = function () {
    if (this.debugProximityTrap != 1) return;

    if (this.debug) {
        log(this.name, 'Ship LAUNCHED.');
        log(this.name, this.TRAPS);
    }
    player.ship.position = system.locationFromCode('OUTER_SYSTEM_OFFPLANE');

    this.$populateWithTrap(player.ship.position.add([1E4, 1E4, 1E4]));
};

this.$pickTrap = function () {
    var x = system.scrambledPseudoRandomNumber(clock.seconds);
    for (var idx = 0; idx < this.TRAPS.length; idx += 5) {
        // log(this.name, x + ' :: ' + idx + ' :: ' + this.TRAPS[idx]);
        if (x < this.TRAPS[idx]) {
            return (idx / 5);
        }
    }
    return (idx / 5);
};

this.$populateWithTrap = function (pos) {
    this.trapType = this.$pickTrap();
    this.trapState = TRAP_ACTIVE;
    if (this.debug) log(this.name, 'initialize trap type: ' + this.trapType);

    // location of the stash
    this.trapPosition = pos;

    // instantiate cargopods
    var pods = Math.floor(system.scrambledPseudoRandomNumber(clock.seconds) * (this.TRAPS[this.trapType * 5 + 2] - this.TRAPS[this.trapType * 5 + 1] + 1)) + this.TRAPS[this.trapType * 5 + 1];

    if (pods != 0)
        system.addShips('cargopod', pods, this.trapPosition, 1000);

    var buoys = system.addShips('nofly_buoy', 1, this.trapPosition, 1000);
    this.buoy = buoys[0];

    this.distanceChecker = new Timer(this, this.$checkDistance, 5, 5);
};

/** launch from station for testing */
this.systemWillPopulate = function (station) {
    if (system.scrambledPseudoRandomNumber(clock.seconds) < this.TrapLikelihood * system.techLevel) {
        //player.commsMessage('This system looks interesting!');
        system.setPopulator('trap', {
            callback: function (pos) {
                this.$populateWithTrap(pos);
            }.bind(this),
            location: 'LANE_WP'
        });
    }
};


/** Timer function callback to check the distance to the player */
this.$checkDistance = function () {

    if (this.trapState != TRAP_ACTIVE) {
        // how can we still be here?
        // nevertheless, defensive programming
        if (this.debug) log(this.name, 'trapstate not active (' + this.trapState + '); disable checker.');
        this.distanceChecker.stop();
        return;
    }

    var ships = system.filteredEntities(this,
        function $isNoFlyBuoy(entity) {
            return (entity.primaryRole == 'nofly_buoy');
        },
        player.ship, 25600);


    if (ships == null) return; // nothing close
    if (ships.length == 0) return; // nothing close

    // de-array
    var ship = ships[0];

    var distance = player.ship.position.distanceTo(ship);

    //log(this.name, 'distance from buoy:' + distance);

    // proximity alert must come first before warning due to 'return' statement
    if (distance < this.proximityAlert) {
        this.trapState = this.TRAP_SPRUNG;
        if (this.debug) log(this.name, 'Stopping timer since the alarm went off.');
        this.distanceChecker.stop();

        //log(this.name, 'issuing alert ('+ (this.trapType * 5 + 4) +'):'+TRAPS[this.trapType * 5 + 4]);

        this.TRAPS[this.trapType * 5 + 4]();
        return;
    }

    if (distance < this.proximityWarning) {
        //log(this.name, 'issuing waring ('+ (this.trapType * 5 + 3) +'): '+TRAPS[this.trapType * 5 + 3]);
        this.TRAPS[this.trapType * 5 + 3]();
        return;
    }
}
