this.name = 'AsteroidTrap';
this.copyright = '(C) 2015 Popsch.';
this.licence = 'CC-NC-by-SA 2.0';

this.debug = false;

'use strict';

/** Distance at which the pirates take off */
this.proximityWarning = 15000;

/** Likelyhood of police trap present */
this.TRAP_LIKELIHOOD = 0.4; // will be divided by the tech level
//this.TRAP_LIKELIHOOD = 1;

this.asteroids = null;
this.announcer = null;

this.distanceChecker = null;

/** launch from station for testing */
this.shipWillLaunchFromStation = function () {
    if (!this.debug) return;

    log(this.name, 'Ship LAUNCHED.');
    player.ship.position = system.locationFromCode('OUTER_SYSTEM_OFFPLANE');

    this.$populateWithTrap(player.ship.position.add([1E4, 1E4, 1E4]));
};

this.$populateWithTrap = function (pos) {
    var asteroidCount = (system.scrambledPseudoRandomNumber(clock.seconds) / 2) * 10 + 2;
    if (this.debug) log(this.name, 'initialized trap with asteroids: ' + asteroidCount);

    // instantiate cargopods
    this.asteroids = system.addShips('piratetrap_asteroid', asteroidCount, pos, 7000);

    this.distanceChecker = new Timer(this, this.$checkDistance, 5);

};

/** populate the system */
this.systemWillPopulate = function (station) {
    if (system.scrambledPseudoRandomNumber(clock.seconds) < this.TRAP_LIKELIHOOD / system.techLevel) {
        system.setPopulator('trap', {
            callback: function (pos) {
                this.$populateWithTrap(pos);
            }.bind(this),
            location: 'LANE_WP'
        });
    }
};

/** Timer function callback to check the distance to the player */
this.$checkDistance = function () {
    var ships = system.filteredEntities(this,
        function $checkAsteroid(entity) {
            return (entity.primaryRole == 'piratetrap_asteroid');
        },
        player.ship, 17000);

    //log(this.name,'timer: '+this.distanceChecker);

    if ((ships == null) || (ships.length == 0)) {
        // nothing close
        this.distanceChecker.stop();
        this.distanceChecker = new Timer(this, this.$checkDistance, 5);
        return;
    }

    // spring the trap
    this.asteroids.forEach(function (entry) {
        var s = system.addShips('pirate', 1, entry.position, 250)[0];
        s.target = player.ship;
        s.performAttack();
        this.announcer = s;
    }.bind(this));

    s.commsMessage(expandMissionText("stashes_trap_surprise"));

    this.distanceChecker.stop();
    this.distanceChecker = null;
};
