"use strict"; 

this.name				= "liners_tigershark.js";
this.author				= "Thargoid";
this.copyright			= "Creative Commons: attribution, non-commercial, sharealike.";
this.description		= "Ship script for Tiger Shark";
this.version			= "1.6.2";

this.shipSpawned = function()
	{
	this.nameShip();
	}
	
this.nameShip = function()
	{
	this.shipTitle = expandDescription('[TigersharkName]');
	if(Math.random() > 0.25)
		{
		this.shipTitle = this.shipTitle + expandDescription('[TigersharkNumber]');
		}
	this.ship.displayName = "TSK " + this.shipTitle;
	}


this.shipEnergyIsLow = function()
	{
	if(!this.shipEvacuated)
		{
		this.shipEvacuated = true;
		this.ship.desiredSpeed = 0;
		var leftPods = Math.ceil(Math.random() * 10) + 5;
		var rightPods = Math.ceil(Math.random() * 10) + 5;
        var leftOrientation = this.ship.orientation.multiply([0.7071, 0, 0.7071, 0]);
        var rightOrientation = this.ship.orientation.multiply([0.7071, 0, -0.7071, 0]);
        var leftVelocity = this.ship.vectorRight.multiply(-150).add(this.ship.velocity);
        var rightVelocity = this.ship.vectorRight.multiply(150).add(this.ship.velocity);
		this.ship.commsMessage("Mayday, mayday! Hull breach imminent, all passengers and non-essential crew to the lifepods!");
		
		var offset, pod, i;
		for(i=0; i < rightPods; i++)
			{
			offset = new Vector3D([350, 0, (Math.random() * 2308) - 1154]);
			pod = system.addShips("escape-capsule", 1, this.ship.position.add(offset.rotateBy(this.ship.orientation)), 0)[0];
            pod.orientation = rightOrientation;
            pod.velocity = rightVelocity;
			}
		
		for(i=0; i < leftPods; i++)
			{
			offset = new Vector3D([-350, 0, (Math.random() * 2308) - 1154]);
			pod = system.addShips("escape-capsule", 1, this.ship.position.add(offset.rotateBy(this.ship.orientation)), 0)[0];
            pod.orientation = leftOrientation;
            pod.velocity = leftVelocity;
			}
		}
	}

this.shipEnergyBecameFull = function()
	{
	this.shipEvacuated = false;
	}
