"use strict"; 

this.name					= "liners_emerald.js";
this.author					= "Thargoid";
this.copyright				= "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description			= "Emerald liner script.";
this.version				= "1.6.2";

(function () {

const escortPositions =
	[
    new Vector3D(-2, 0,  2),
    new Vector3D(-2, 0,  -2),
    new Vector3D( 2, 0,  2),
    new Vector3D( 2, 0, -2),
    new Vector3D(2, 0, 0),
    new Vector3D(-2, 0,  0)
	];

const escortPositionCount = escortPositions.length;
const escortSpacingFactor = 3;


this.coordinatesForEscortPosition = function (index, count)
	{
    var highPart = Math.floor(index / escortPositionCount) + 1;
    var lowPart = index % escortPositionCount;
    
    var spacing = this.ship.collisionRadius * escortSpacingFactor * highPart;
    
    return escortPositions[lowPart].multiply(spacing);
	}

	}).call(this);

this.shipSpawned = function()
	{
	this.linerGroup = this.ship.group;
	this.linerGroup.leader = this.ship;
	this.launchChance = 0;
	this.counterArray = [0,0,0,0];
	this.posArray = [];
	this.IDArray = [0,0,0,0];
	var subCounter = 0 ; // reset the counter
	for(subCounter = 0;subCounter<this.ship.subEntities.length;subCounter++)
		{
		if(this.ship.subEntities[subCounter].hasRole("liners_emeraldShuttle"))
			{ this.posArray.push(this.ship.subEntities[subCounter].position) }
		}	
	this.nameShip();
	if(Math.random() > 0.75)
		{
		this.ship.switchAI("liners_emeraldWAI.plist");
		}
	}	
	
this.nameShip = function()
	{
	this.nameArray = ["XXXX", "Titanic", "Olympic", "Galactica", "Andromeda", "Kessel", "Aegidian", "Aqualina", "Antilles", "Dark Star", "Atlantis", "Discovery", "Kobayashi Maru", "Bermuda Cube", "Nebula", "Empiric", "Majestic", "Emerald Moon", "Empress of Ryaxaxax", "Far Sky", "Fuji Maru", "Imperator", "XXXX", "Independence", "Leviathan", "Maelstrom", "Meridian", "Michelangelo", "Millenium", "Neptune", "Neptunia", "Oceania", "Oceanic", "Orca", "Republic", "Resolute", "Saturnia", "Soyuz", "Valkerie", "Valhalla", "Star Dancer", "Solaris", "Victory", "Viking", "XXXX", "Vulcan", "Concorde", "Wolf", "Adonis", "Poseidon", "Zeus", "Apollo", "Eagle", "Phoenix", "Adventurer", "Odyssey", "Dolphin", "Allure", "Amadeus", "Adamant", "Spirit", "Aquamarine", "Arcadia", "XXXX", "Calypso", "Conquest", "Freedom", "Imagination", "Inspiration", "Legend", "Liberty", "Constellation", "Infinity", "Heart of Gold", "Solstice", "Mercury", "Jupiter", "Saturn", "Mars", "Crystal", "Symphony", "Melody", "Ambassador", "Rhapsody", "Wonder", "XXXX", "Dream Weaver", "Dreamer", "Elation", "Enchanter", "Enchantment", "Illusion", "Conjurer", "Magii", "Far Star", "XXXX", "Venturer", "Jubilee", "Sun Skimmer", "Lucky", "Preen", "Lucky Star", "Brigadoon", "Mardi Gras", "Carnival", "Festival", "Samba", "Tango", "Mariner", "Minerva", "Fantasia", "Opera", "Firefox", "Explorer", "Oasis", "Orion", "Platinum", "Aloha", "Radiant", "Regal", "Renaissance", "Princess", "Royale", "Rose", "Wonder", "Sovereign", "Vista", "Capricorn", "Aquarius", "Pisces", "Aries", "Taurus", "Gemini", "Leo", "Virgo", "Libra", "Scorpio", "Corona", "Wind Song", "Zion", "XXXX"];
	this.nameChoice = Math.floor(Math.random() * this.nameArray.length);
	this.shipTitle = this.nameArray[this.nameChoice]
	if(this.shipTitle !== "XXXX")
		{ this.ship.displayName = "ASL " + this.shipTitle; }
	else
		{
		this.titleArray = ["Maid", "Queen", "Empress", "Moons", "Freedom", "Majesty", "Splendour", "Magic", "Memories", "Tales", "Spirit"];
		this.titleChoice = Math.floor(Math.random() * this.titleArray.length);
		this.systemName = System.systemNameForID(Math.floor(Math.random() * 256));
		this.ship.displayName = this.titleArray[this.titleChoice] + " of " + this.systemName;
		this.shipTitle = this.titleArray[this.titleChoice] + " of " + this.systemName;
		}
	}

this.beginUnload = function()
	{
	this.launchChance = 0;
	this.ship.commsMessage("WARNING - This is the Emerald class liner ASL " + this.shipTitle + ". Please exercise caution around this region as we are beginning our disembarkation process.");
	}

this.endUnload = function()
	{
	this.launchChance = 0;
	this.ship.AIState = "DEPART";
	this.ship.commsMessage("This is the ASL " + this.shipTitle + ". Our disembarkation for " + system.name + " is now completed.");
	}

this.beginLaunch = function()
	{
	if(Math.random() < this.launchChance) // ending launches and ship out
		{
		this.endUnload();
		return;
		}
		
	if(Math.random() > 0.5 && this.counterArray[0] === 0) // 50% chance of launching upper port shuttle
		{ 
		this.launchShuttle(0);
		this.launchChance += 0.01;
		} 
	
	if(Math.random() > 0.5 && this.counterArray[1] === 0) // 50% chance of launching upper starboard shuttle
		{ 
		this.launchShuttle(1);
		this.launchChance += 0.01;
		} 
		
	if(Math.random() > 0.5 && this.counterArray[2] === 0) // 50% chance of launching lower port shuttle
		{ 
		this.launchShuttle(2);
		this.launchChance += 0.01;
		} 
	
	if(Math.random() > 0.5 && this.counterArray[3] === 0) // 50% chance of launching lower starboard shuttle
		{ 
		this.launchShuttle(3);
		this.launchChance += 0.01;
		} 	
	
	this.launchChance += 0.01;	// increment the chance of departure by 1% in any case.
	}

this.launchShuttle = function(subEnt)
	{
	switch(subEnt)
		{
		case 0:
			{
			this.callback = addFrameCallback(this.movePTShuttle.bind(this));
			this.IDArray[0] = this.callback;
			break;
			}
		case 1:
			{
			this.callback = addFrameCallback(this.moveSTShuttle.bind(this));
			this.IDArray[1] = this.callback;
			break;
			}
		case 2:
			{
			this.callback = addFrameCallback(this.movePBShuttle.bind(this));
			this.IDArray[2] = this.callback; 
			break;
			}
		case 3:
			{
			this.callback = addFrameCallback(this.moveSBShuttle.bind(this));
			this.IDArray[3] = this.callback; 
			break;
			}
		}	
	
	this.callback = 0;
	}

this.movePTShuttle = function(delta)
	{
	if(delta === 0) {return;} // so we're not moving things when the game is paused
	this.moveShuttle(0);
	}

this.moveSTShuttle = function(delta)
	{
	if(delta === 0) {return;} // so we're not moving things when the game is paused
	this.moveShuttle(1);
	}
	
this.movePBShuttle = function(delta)
	{
	if(delta === 0) {return;} // so we're not moving things when the game is paused
	this.moveShuttle(2);
	}

this.moveSBShuttle = function(delta)
	{
	if(delta === 0) {return;} // so we're not moving things when the game is paused
	this.moveShuttle(3);
	}	
	
this.moveShuttle = function(subEnt)
	{
	this.ship.subEntities[subEnt].position = this.ship.subEntities[subEnt].position.add(this.ship.subEntities[subEnt].vectorForward);
	this.counterArray[subEnt]++;
	if(this.counterArray[subEnt] > 500)
		{
		if(this.IDArray[subEnt] !== 0)
			{ 
			removeFrameCallback(this.IDArray[subEnt]); 
			this.IDArray[subEnt] = 0;
			this.swapShuttle(subEnt);
			}
		this.counterArray[subEnt] = 0;	
		}
	}
	
this.swapShuttle = function(subEnt)
	{
	this.subPosition = this.ship.subEntities[subEnt].position;
	this.subOrientation = this.ship.subEntities[subEnt].orientation;
	this.ship.subEntities[subEnt].position = this.posArray[subEnt]; 
	let subShuttle = this.ship.spawnOne("liners_jade"); 
	subShuttle.position = this.localToGlobal(this.subPosition); 
	subShuttle.orientation = this.subOrientation.multiply(this.ship.orientation); 
	subShuttle.velocity = subShuttle.vectorForward;
	subShuttle.desiredSpeed = subShuttle.maxSpeed;
	this.linerGroup.addShip(subShuttle);
	subShuttle.group = this.ship.group;
	if(Math.random() > 0.33)
		{
		subShuttle.target = system.mainStation;
		subShuttle.switchAI("liners_dockingShuttleAI.plist"); 
		}
	else
		{ subShuttle.switchAI("liners_landingShuttleAI.plist"); }
	}
	
this.localToGlobal = function(position)
	{ // sub-ent position is relative to mother, but for swapping we need the absolute global position
	let orientation = this.ship.orientation;
	return this.ship.position.add(position.rotateBy(orientation));
	}

this.playerWillEnterWitchspace = this.shipWillEnterWormhole = this.shipRemoved = this.shipDied = function ()
	{ this.stopCallbacks();	}	
	
this.stopCallbacks = function()
	{
	var IDCounter = 0 ; // reset the counter
	for(IDCounter = 0;IDCounter<this.IDArray.length;IDCounter++)
		{
		if(this.IDArray[IDCounter] !== 0)
			{
			removeFrameCallback(this.IDArray[IDCounter]); 
			this.IDArray[IDCounter] = 0;
			}
		}	
	}	
