"use strict";
this.name = "AnacondaCruiseLiners_shipScript";
this.author = "phkb";
this.copyright = "2025 phkb";
this.license = "CC BY-NC-SA 4.0";

this._debug = false;

//----------------------------------------------------------------------------------------
this.shipSpawned = function() {
	this._debug = worldScripts.AnacondaCruiseLiners._debug;
}

//----------------------------------------------------------------------------------------
this.shipEnteredStationAegis = function (station) {
	if (this._debug) log(this.name, "entered aegis of " + station);
}

//----------------------------------------------------------------------------------------
this.shipWillDockWithStation = function (station) {
	if (this._debug) log(this.name, "docked at " + station);
}

//----------------------------------------------------------------------------------------
this.shipWillEnterWormhole = function () {
	if (this._debug) log(this.name, "entered wormhole to " + this.ship.destinationSystem + " " + System.systemNameForID(this.ship.destinationSystem));
}

//----------------------------------------------------------------------------------------
this.shipBeingAttacked = function (whom) {
	if (this._debug) log(this.name, "being attached by " + whom);
}

//----------------------------------------------------------------------------------------
this.shipAcceptedEscort = function (newEscort) {
	if (this._debug) log(this.name, "accepted escort from " + newEscort);
}

//----------------------------------------------------------------------------------------
this.shipDied = function (whom, why) {
	if (this._debug) log(this.name, "ship died because of " + why + " from " + whom);
}

//----------------------------------------------------------------------------------------
this.$selectWitchspaceDestination = function () {
	var acl = worldScripts.AnacondaCruiseLiners;
	var locals = system.info.systemsInRange(6.5);
	if (acl._selectedDataSet == expandMissionText("acl_allsystems")) {
		// if we have all systems selected, just pick a random destination
		next = locals[Math.floor(Math.random() * locals.length)].systemID;
	} else {
		var currentIndex = acl._data[galaxyNumber].indexOf(system.ID);
		var next = -1;
		if (acl._data[galaxyNumber].length > currentIndex + 2) {
			next = acl._data[galaxyNumber][currentIndex + 1];
			//this.ship.destinationSystem = next;
		}
		var found = false;
		for (var i = 0; i < locals.length; i++) {
			if (next >= 0 && locals[i].systemID == next) found = true;
		}
		if (!found) {
			for (var i = 0; i < locals.length; i++) {
				if (acl._data[galaxyNumber].indexOf(locals[i].systemID) >= 0) {
					next = locals[i].systemID;
				}
			}
		}
	}
	if (this._debug) log(this.name, expandMissionText("acl_log_set_destination", { id: next, name: System.systemNameForID(next) }));
	this.ship.destinationSystem = next;
}

//----------------------------------------------------------------------------------------
this.$exitSystemForDestination = function () {
	var dest = System.infoForSystem(galaxyNumber, this.ship.destinationSystem);
	var dist = system.info.distanceToSystem(dest);
	var result = this.ship.exitSystem(this.ship.destinationSystem);
	if (result) {
		this.ship.fuel -= dist;
	} else {
		this.ship.sendAIMessage("WITCHSPACE BLOCKED");
	}
}