"use strict";
this.name = "sentinelstation_market";
this.author = "spara";
this.copyright = "2014 spara";
this.license     = "CC BY-NC-SA 4.0";

this.$originalDefs = {
      "food" : [0, 0, 43, -3, 0, -1, 7, 5, 0],
      "textiles" : [0, 0, 33, -2, 0, -1, 7, 7, 0],
      "radioactives" : [0, 0, 65, -3, -3, 2, 7, 7, 0],
      "slaves" : [0, 0, 37, -5, -31, -189, 73, 7, 0],
      "liquor_wines" : [0, 0, 29, 5, -5, 251, 15, 15, 0],
      "luxuries" : [0, 0, 163, 11, 8, 54, 15, 3, 0],
      "narcotics" : [0, 0, 205, 5, 29, 8, 15, 0, 0],
      "computers" : [0, 0, 154, 14, 14, 56, 3, 3, 0],
      "machinery" : [0, 0, 117, 6, 6, 40, 7, 7, 0],
      "alloys" : [0, 0, 78, 1, 1, 17, 31, 31, 0],
      "firearms" : [0, 0, 136, 13, 13, 29, 28, 0, 0],
      "furs" : [0, 0, 176, -9, -9, 220, 63, 63, 0],
      "minerals" : [0, 0, 32, -1, -1, 53, 3, 3, 0],
      "gold" : [0, 0, 107, -1, -1, 66, 7, 7, 1],
      "platinum" : [0, 0, 185, -2, -2, 55, 31, 31, 1],
      "gem_stones" : [0, 0, 55, -1, -1, 250, 15, 15, 2],
      "alien_items" : [0, 0, 21, 15, 0, 0, 63, 0, 0]
};

this.updateLocalCommodityDefinition = function(goodDefinition) {
	var commodity = goodDefinition.key;
	var oldDefs = this.$originalDefs[commodity];
	//old style definition found for the good. calculate it the old way
	if (oldDefs) {
		var market_base_price = oldDefs[2];
		var market_eco_adjust_price = oldDefs[3];
		var market_eco_adjust_quantity = oldDefs[4];
		var market_base_quantity = oldDefs[5];
		var market_mask_price = oldDefs[6];
		var market_mask_quantity = oldDefs[7];
		var market_rnd = Math.floor(Math.random() * 256);

		var economy = system.economy;

		var price = (market_base_price + (market_rnd & market_mask_price) + (economy * market_eco_adjust_price)) & 255;
		price *= 0.4;

		var quantity = (market_base_quantity + (market_rnd & market_mask_quantity) - (economy * market_eco_adjust_quantity)) & 255;
		if (quantity > 127) quantity = 0;
		quantity &= 63;

		goodDefinition.price = price * 10;
		goodDefinition.quantity = quantity;
	}
	//no definition found. nullify the goods.
	else {
		goodDefinition.price = 0;
		goodDefinition.quantity = 0;
	}
	return goodDefinition;
};
