"use strict";
this.name = "hackeroutpost_market";
this.author = "spara";
this.copyright = "2014 spara";
this.license     = "CC BY-NC-SA 4.0";

this.$originalDefs = {
      "food" : [0, 0, 47, -8, -1, -3, 12, 3, 0],
      "textiles" : [0, 0, 55, -9, -1, -1, 15, 3, 0],
      "radioactives" : [0, 0, 45, -5, -3, 0, 15, 7, 0],
      "slaves" : [0, 0, 6, 0, 0, 0, 7, 0, 0],
      "liquor_wines" : [0, 0, 128, 0, 0, 0, 63, 0, 0],
      "luxuries" : [0, 0, 236, 4, 1, -1, 7, 3, 0],
      "narcotics" : [0, 0, 208, 0, 0, 0, 79, 0, 0],
      "computers" : [0, 0, 82, 7, 5, 25, 15, 15, 0],
      "machinery" : [0, 0, 103, 6, 6, 20, 7, 7, 0],
      "alloys" : [0, 0, 124, 1, 1, 2, 15, 3, 0],
      "firearms" : [0, 0, 159, 5, 0, 0, 15, 0, 0],
      "furs" : [0, 0, 170, 0, 0, 0, 31, 0, 0],
      "minerals" : [0, 0, 24, -1, -1, 7, 3, 15, 0],
      "gold" : [0, 0, 110, -1, -1, -2, 7, 5, 1],
      "platinum" : [0, 0, 195, -2, -2, -1, 15, 3, 1],
      "gem_stones" : [0, 0, 54, -1, -1, 3, 7, 3, 2],
      "alien_items" : [0, 0, 137, 0, 0, 0, 31, 0, 0]
};

this.updateLocalCommodityDefinition = function(goodDefinition) {
	var commodity = goodDefinition.key;
	var oldDefs = this.$originalDefs[commodity];
	//old style definition found for the good. calculate it the old way
	if (oldDefs) {
		var market_base_price = oldDefs[2];
		var market_eco_adjust_price = oldDefs[3];
		var market_eco_adjust_quantity = oldDefs[4];
		var market_base_quantity = oldDefs[5];
		var market_mask_price = oldDefs[6];
		var market_mask_quantity = oldDefs[7];
		var market_rnd = Math.floor(Math.random() * 256);

		var economy = system.economy;

		var price = (market_base_price + (market_rnd & market_mask_price) + (economy * market_eco_adjust_price)) & 255;
		price *= 0.4;

		var quantity = (market_base_quantity + (market_rnd & market_mask_quantity) - (economy * market_eco_adjust_quantity)) & 255;
		if (quantity > 127) quantity = 0;
		quantity &= 63;

		goodDefinition.price = price * 10;
		goodDefinition.quantity = quantity;
	}
	//no definition found. nullify the goods.
	else {
		goodDefinition.price = 0;
		goodDefinition.quantity = 0;
	}
	return goodDefinition;
};
