"use strict";
this.name        = "Anarchies_Conditions";
this.author      = "phkb";
this.copyright   = "2015 phkb";
this.description = "Condition script for ships and equipment.";
this.licence     = "CC BY-NC-SA 3.0";

this.allowSpawnShip = function(shipKey) {
	switch (shipKey) {
		case "anarchies-renegade_viper":
			if (system.info.government < 2) return true;
			break;
		case "anarchies-scavenger-phoenix":
			if (system.info.government === 0) return true;
			break;
		
	}
	return false;
}

this.allowAwardEquipment = function(equipment, ship, context) {
	if (context === "scripted") return true;
    var _dockedStation = player.ship.dockedStation;
    
    switch (equipment) {
        case "EQ_MULTIPASS":
            if (_dockedStation && _dockedStation.name === "Hacker Outpost" && system.info.government === 0) return true;
            break;
        case "EQ_MULTIPASSED_ID":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && system.info.government === 0) return true;
            break;
        case "EQ_ECM_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_ecm_chance > 65) return true;
            break;
        case "EQ_FUEL_SCOOPS_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_fuel_scoops_chance > 65) return true;
            break;
        case "EQ_ESCAPE_POD_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_escape_pod_chance > 75) return true;
            break;
        case "EQ_ENERGY_BOMB_SALVAGED":
            if (!EquipmentInfo.infoForKey("EQ_ENERGY_BOMB")) return false; // if the energy bomb OXP is not installed, don't offer a salvaged one
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_energy_bomb_chance > 75) return true;
            break;
        case "EQ_ENERGY_UNIT_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_energy_unit_chance > 80) return true;
            break;
        case "EQ_NAVAL_ENERGY_UNIT_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_naval_unit_chance > 90) return true;
            break;
        case "EQ_DOCK_COMP_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_dock_comp_chance > 75) return true;
            break;
        case "EQ_GAL_DRIVE_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_gal_drive_chance > 85) return true;
            break;
        case "EQ_FUEL_INJECTION_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_injectors_chance > 65) return true;
            break;
        case "EQ_SCANNER_SHOW_MISSILE_TARGET_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_target_enhancement_chance > 65) return true;
            break;
        case "EQ_MULTI_TARGET_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_multi_target_chance > 65) return true;
            break;
        case "EQ_ADVANCED_COMPASS_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_adv_compass_chance > 65) return true;
            break;
        case "EQ_ADVANCED_NAVIGATIONAL_ARRAY_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_adv_array_chance > 75) return true;
            break;
        case "EQ_TARGET_MEMORY_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_target_memory_chance > 65) return true;
            break;
        case "EQ_SHIELD_BOOSTER_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_shield_booster_chance > 75) return true;
            break;
        case "EQ_NAVAL_SHIELD_BOOSTER_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_naval_booster_chance > 85) return true;
            break;
        case "EQ_HEAT_SHIELD_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_heat_shield_chance > 75) return true;
            break;
        case "EQ_WORMHOLE_SCANNER_SALVAGED":
            if (_dockedStation && _dockedStation.name === "Salvage Gang" && missionVariables.salvaged_wormhole_scanner_chance > 80) return true;
            break;
    }
    return false;
}