/*

anarchies-sentinel-station-patrol-script.js

Ship script for Sentinel Station Patrols.


Oolite
Copyright © 2004-2012 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.


Anarchies.oxp
Copyright © 2007-2012 "Commander McLane"

This work is licensed under the Creative Commons
Attribution-Noncommercial-Share Alike 3.0 Unported License.

To view a copy of this license, visit
http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter
to Creative Commons, 171 Second Street, Suite 300, San Francisco,
California, 94105, USA.

*/

"use strict";

this.name           = "anarchies-sentinel-station-patrol-script";
this.description    = "Ship script for Sentinel Station Patrols";
this.author         = "Commander McLane";
this.copyright      = "© 2012 Commander McLane";
this.license		= "CC-by-nc-sa 3.0";
this.version        = "2.8";


this.$requestPatrolCoordinates = function()
{
    // if the Sentinel Station was destroyed, the patrol ships turn into normal police
    if(!this.ship.group.leader)
    {
        this.ship.switchAI("route1patrolAI.plist");
        return;
    }
    // depending on the patrol's current position it gets a new destination around the station
    switch(this.ship.AIState)
    {
        case "HEAD_FOR_PATROLPOINT_1":
            this.ship.savedCoordinates = this.ship.group.leader.position.add(this.ship.group.leader.vectorForward.multiply(-30000));
            break;
        
        case "HEAD_FOR_PATROLPOINT_2":
            this.ship.savedCoordinates = this.ship.group.leader.position.add(this.ship.group.leader.vectorUp.multiply(15000));
            break;
        
        case "HEAD_FOR_PATROLPOINT_3":
            this.ship.savedCoordinates = this.ship.group.leader.position.add(this.ship.group.leader.vectorForward.multiply(30000));
    }
}

this.$scanForRandomOffender = function()
{
    // the normal scan for offenders doesn't work in anarchies, therefore we're doing it by script
    // details in anarchies-sentinel-station-script.js
    function $isOffender(entity)
    {
        return entity.isShip && entity.scanClass !== "CLASS_ROCK" && entity.scanClass !== "CLASS_CARGO" && !entity.isCloaked && entity.bounty - randomBlindness > 0
    }
    var randomBlindness = Math.floor(Math.random() * 50);
    var offenders = system.filteredEntities(this, $isOffender, this.ship, 25600);
    if(offenders.length === 0)
    {
        this.ship.sendAIMessage("NOTHING_FOUND");
    }
    else
    {
        var targetedOffender = offenders[Math.floor(Math.random() * offenders.length)];
        this.ship.target = targetedOffender;
        this.ship.sendAIMessage("TARGET_FOUND");
    }
}