/*

anarchies-salvage-gang-script.js

Script for turning Salvage Gangs towards the planet and creating an asteroid field around them, and broadcast advertisements.


Oolite
Copyright © 2004-2012 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.


Anarchies.oxp
Copyright © 2007-2012 "Commander McLane"

This work is licensed under the Creative Commons
Attribution-Noncommercial-Share Alike 3.0 Unported License.

To view a copy of this license, visit
http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter
to Creative Commons, 171 Second Street, Suite 300, San Francisco,
California, 94105, USA.

*/

"use strict";

this.name           = "anarchies-salvage-gang-script";
this.description    = "Ship script for Salvage Gangs";
this.author         = "Commander McLane";
this.copyright      = "© 2012 Commander McLane";
this.license		= "CC-by-nc-sa 3.0";
this.version        = "2.8";


this.shipSpawned = function()
{
    // asteroid is aligned towards the z-axis and therefore towards the planet
    this.ship.orientation = [1, 0, 0, 0];
    // an asteroid cluster is added around the outpost
    system.addShips("asteroid", 20, this.ship.position, 15000);
    // timer for broadcasting advertising messages is started
	this.messageTimer = new Timer(this, this.$broadcastMessage, 30, 30);
}

this.$broadcastMessage = function()
{
    // one of the messages defined in descriptions.plist is broadcast
    if(!player.ship.docked) this.ship.commsMessage(expandDescription("[anarchies_salvageGang_hail]"));
    // the interval until the next broadcast is set at a random value between 40 and 60 seconds
    this.messageTimer.interval = 40 + (Math.random() * 20);
}

this.playerWillEnterWitchspace = this.shipDied = function()
{
    // the broadcast timer is stopped and deleted when the player leaves the system
    this.messageTimer.stop();
    delete this.messageTimer;
}
