/*

anarchies-henchman-script.js

Ship script for the Hacker Henchmen.


Oolite
Copyright © 2004-2012 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.


Anarchies.oxp
Copyright © 2007-2012 "Commander McLane"

This work is licensed under the Creative Commons
Attribution-Noncommercial-Share Alike 3.0 Unported License.

To view a copy of this license, visit
http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter
to Creative Commons, 171 Second Street, Suite 300, San Francisco,
California, 94105, USA.

*/

"use strict";

this.name           = "anarchies-henchman-script";
this.description    = "Ship script for Hacker Henchmen";
this.author         = "Commander McLane";
this.copyright      = "© 2012 Commander McLane";
this.license		= "CC-by-nc-sa 3.0";
this.version        = "2.8";


this.shipSpawned = function()
{
    this.ship.primaryRole = "pirate";
}

this.$checkPlayerLegalStatus = function()
{
	if(player.bounty >= 15) this.ship.reactToAIMessage("PLAYER_OFFENDER");
	else this.ship.reactToAIMessage("PLAYER_CLEAN");
}

this.$createHackerOutpost = function()
{
	var selectPosition = Math.ceil(Math.random()*4);
	switch(selectPosition)
	{
	case 1:
		system.legacy_addShipsAtPrecisely("anarchies_hacker_outpost", 1, "wpm", [50000, -100000, -200000]);
		break;
		
	case 2:
		system.legacy_addShipsAtPrecisely("anarchies_hacker_outpost", 1, "pwm", [100000, 75000, -350000]);
		break;
		
	case 3:
		system.legacy_addShipsAtPrecisely("anarchies_hacker_outpost", 1, "pwu", [0, 0.75, 0.5]);
		break;
		
	case 4:
		system.legacy_addShipsAtPrecisely("anarchies_hacker_outpost", 1, "psu", [0, 0.6, 0.5]);
		break;
	}
	this.$removeOtherHenchman();
}

this.$removeOtherHenchman = function()
{
	// remove the other henchman if it didn't die already for some other reason
    if(system.shipsWithRole("anarchies_henchman", player.ship)[1])
        system.shipsWithRole("anarchies_henchman", player.ship)[1].remove();
}

this.shipEnergyIsLow = function ()
{
	if(system.countShipsWithRole("anarchies_hacker_outpost") === 0 && this.ship.target === player.ship)
	{
		if(!this.attackCounter) this.attackCounter = 1;
		switch(this.attackCounter)
		{
		case 1:
			this.ship.commsMessage("Please stop!");
			this.ship.energy *= 1.5;
			break;
			
		case 2:
			this.ship.commsMessage("I've got some information for you.");
			this.ship.energy *= 1.5;
			break;
			
		case 3:
			this.ship.commsMessage("There's a Hacker Outpost in this system.");
			this.ship.energy *= 1.5;
			break;
			
		case 4:
			this.ship.commsMessage("Follow the 'H' on your compass and let me go!");
			this.$createHackerOutpost();
			break;
		}
		this.attackCounter ++;
	}
}

this.shipDied = function()
{
	delete this.attackCounter;
}
