/*

anarchies-hacker-outpost-script.js

Script for turning Hacker Outposts towards the planet and moving their Sentinel Asteroids.


Oolite
Copyright © 2003-2012 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.


Anarchies.oxp
Copyright © 2007-2012 "Commander McLane"

This work is licensed under the Creative Commons
Attribution-Noncommercial-Share Alike 3.0 Unported License.

To view a copy of this license, visit
http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter
to Creative Commons, 171 Second Street, Suite 300, San Francisco,
California, 94105, USA.

*/

"use strict";

this.name           = "anarchies-hacker-outpost-script";
this.description    = "Ship script for Hacker Outposts";
this.author         = "Eric Walch & Commander McLane";
this.copyright      = "© 2012 Commander McLane";
this.license		= "CC-by-nc-sa 3.0";
this.version        = "2.8";


this.shipSpawned = function()
{
    // next line sets up a vector outpost --> planet
    var targetVector = system.mainPlanet.position.subtract(this.ship.position).direction();
    // next line aligns the heading to the targetVector by rotating
    this.ship.orientation = targetVector.rotationTo(new Vector3D(0,0,1));
    // an asteroid cluster is added around the outpost
    system.addShips("asteroid", 20, this.ship.position, 15000);

    // next line starts a timer for broadcasting advertising messages
	this.messageTimer = new Timer(this, this.$broadcastMessage, 30, 30);
}

this.$broadcastMessage = function()
{
    // one of the messages defined in descriptions.plist is broadcast
    if(!player.ship.docked) this.ship.commsMessage(expandDescription("[anarchies_hackerOutpost_hail]"));
    // the interval until the next broadcast is set at a random value between 40 and 60 seconds
    this.messageTimer.interval = 40 + (Math.random() * 20);
}

this.$moveSentinels = function()
{
    // set position for all sentinels
    for (var i=1; i<this.ship.escortGroup.ships.length; i++)
    {
        // copy the ship orientation into the sentinels
        this.ship.escortGroup.ships[i].orientation = this.ship.orientation;
        // place them within 6000 meters around the mother
        this.ship.escortGroup.ships[i].position = this.ship.position.add(Vector3D.random(6000));
    }
}

this.otherShipDocked = function(ship)
{
	if(ship.isPlayer)
	{
		// makes the cloaking device repairable--but not buyable--on a Hacker Outpost
        this.cloakingDeviceDefaultTechLevel = EquipmentInfo.infoForKey("EQ_CLOAKING_DEVICE").effectiveTechLevel;
		if(player.ship.equipmentStatus("EQ_CLOAKING_DEVICE") == "EQUIPMENT_DAMAGED") EquipmentInfo.infoForKey("EQ_CLOAKING_DEVICE").effectiveTechLevel = 10;
	}
}

this.stationLaunchedShip = function(ship)
{
	if(ship.isPlayer)
	{
		// restores the tech level setting for the cloaking device
        EquipmentInfo.infoForKey("EQ_CLOAKING_DEVICE").effectiveTechLevel = this.cloakingDeviceDefaultTechLevel;
	}
}

this.playerWillEnterWitchspace = this.shipDied = function()
{
    // the broadcast timer is stopped and deleted when the player leaves the system
    this.messageTimer.stop();
    delete this.messageTimer;
}
