"use strict";
this.name = "HomeSystem_Book";
this.author = "phkb";
this.description = "Adds the Home System Handbook to the Ship's Library";

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
    if (worldScripts["Ships Library"]) this._registerBook();
}

//-------------------------------------------------------------------------------------------------------------
this._registerBook = function () {
    var contents = [
        { level: 0, key: "homesystem_intro" },
        { level: 1, key: "homesystem_chap1" },
        { level: 1, key: "homesystem_chap2", 
            params: [
                function() {return (worldScripts.DayDiplomacy_060_Citizenships ? expandMissionText("homesystem_diplomacy") : "")}
            ]
        },
        { level: 1, key: "homesystem_chap3", 
            params: [
                function () { return (worldScripts["Docking Fees"] ? expandMissionText("homesystem_dockingfees") : ""); }, 
                function () { return (worldScripts.GalCopBB_Missions ? expandMissionText("homesystem_galcopmissions") : ""); }
            ]
        },
        { level: 1, key: "homesystem_chap4" },
        { level: 1, key: "homesystem_chap5" },
        { level: 0, key: "homesystem_conclusion" },
    ];

    worldScripts["Ships Library"]._registerBook("home_system", expandMissionText("homesystem_title"), contents, 21);
}
