(
function(){

"use strict";
this.name        = "HomeSystem_Conditions";
this.author      = "phkb";
this.copyright   = "2017 phkb";
this.description = "Condition script for Home System equipment";
this.license     = "CC BY-NC-SA 4.0";

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function(equipment, ship, context) {
    if (context == "scripted") return true;
    let w = worldScripts.HomeSystem;
    if (equipment === "EQ_HOMESYSTEM_INVEST") return (w.$homeSystemCount() > 0)
    if (w._stationTypes.indexOf(player.ship.dockedStation.allegiance) >= 0) {
        if (w.$isHomeSystem(system.ID) === false) {
            if (equipment === "EQ_HOMESYSTEM_CLEAN" && player.ship.bounty === 0) return true;
            if (equipment === "EQ_HOMESYSTEM_OFFENDER" && player.ship.bounty > 0 && player.ship.bounty < 50) return true;
            if (equipment === "EQ_HOMESYSTEM_FUGITIVE" && player.ship.bounty >= 50) return true;
        }
        if (equipment === "EQ_HOMESYSTEM_REMOVE" && w.$isHomeSystem(system.ID) === true) return true; 
    }
	return false;
}

}).call(this);