"use strict";
this.name        = "EmailSystemDemo";
this.author      = "phkb";
this.copyright   = "2015 phkb";
this.description = "Demonstrates how to make use of the EmailSystem addon.";
this.version     = "1.1.1";
this.licence     = "CC BY-NC-SA 4.0";

// specific settings for this oxp
this._destination = -1;
this._processState = 0;			// current state of play

//=============================================================================================================
// set up initial variables
this.startUp = function() {
	if (missionVariables.EmailSystemDemo_ProcessState != null) {
		// load up our mission variables
		this._processState = parseInt(missionVariables.EmailSystemDemo_ProcessState);
		this._destination = parseInt(missionVariables.EmailSystemDemo_Destination);
	}
}

this.startUpComplete = function() {

	// connect to the email system
	var w = worldScripts.EmailSystem;

	if (w) {
		if (this._processState == 0) {
			// send initial email
			var p = player.ship;
			if(p && p.isValid) {
				w.$createEmail({sender:"The Chaser",
					subject:"Something for you do look at...",
					date:global.clock.seconds,
					message:"Would you like to play a game?",
					expiryMinutes:5,
					expiryOptions:"3",
					expiryText:"This email has expired",
					allowExpiryCancel:false,
					option1:{display:"Yes", reply:"Sure. Why not? Sounds like fun.", script:"EmailSystemDemo", callback:"$AcceptChallenge"},
					option2:{display:"No", reply:"Sorry. Too busy right now. And I don't play games.", script:"EmailSystemDemo", callback:"$DeclineChallenge"},
					option3:{display:"Too late", reply:"Sorry I didn't respond to your email in time. Can I still join in?", script:"EmailSystemDemo", callback:"$TooLate"}}
					);
				this._processState = 1;
			}
		}
	}
}

this.playerWillSaveGame = function() {

	// save our mission variables
	missionVariables.EmailSystemDemo_ProcessState = this._processState;
	missionVariables.EmailSystemDemo_Destination = this._destination;

}

this.shipDockedWithStation = function(station) {

	// connect to the email system,
	var w = worldScripts.EmailSystem;

	if (w) {
		// check if we're currently in the process
		if (this._processState == 2) {
			// check if we've reached the destination
			if (global.system.ID == this._destination && station.isMainStation) {
				// send the congrats message
				w.$createEmail({sender:"The Chaser",
					subject:"Congratulations!",
					date:global.clock.seconds,
					message:"You found me! Well done. The game is now over. Tell me, did you enjoy the chase?",
					forceResponse:true,
					option1:{display:"Yes", reply:"Absolutely! It was seriously fun.", script:"EmailSystemDemo", callback:"$Result", parameter:"good"},
					option2:{display:"No", reply:"Are you kidding? I was so bored I almost died. Get me out of here.", script:"EmailSystemDemo", callback:"$Result", parameter:"bad"}}
				);
				// set the next state of the process
				this._processState = 3;
			}
		}
	}
}

this.$AcceptChallenge = function() {

	// connect to the email system,
	var w = worldScripts.EmailSystem;

	// find a planet > 10 and < 30ly away
	var dist = 0;
	var dest = -1;
	var range = 30;
	do {
		for (var i = 0; i <= 255; i++) {
			dist = System.infoForSystem(galaxyNumber, global.system.ID).distanceToSystem(System.infoForSystem(galaxyNumber, i));
			if (dist > 10 && dist < range) {
				dest = i;
				break;
			}
		}
		// in case there's no planet in the initial 7-20 range, increase the range until there's a hit
		if (dest == -1) {
			range += 10;
		}
	} while (dest == -1);

	// store our destination
	this._destination = dest;
	// send a new email (this one will have a trace route on it - the player needs to look at the trace to see where they have to go
	w.$createEmail({sender:"The Chaser",
		subject:"The game is on",
		date:global.clock.seconds,
		message:"Excellent. I look forward to seeing you soon! You will receive an email when you dock in the system I'm hiding in.\n\nGood luck, Commander.",
		sentFrom:dest}
	);
	// update the process
	this._processState = 2;

}

this.$DeclineChallenge = function() {

	// connect to the email system,
	var w = worldScripts.EmailSystem;

	// send a new email
	w.$createEmail({sender:"The Chaser",
		subject:"RE: Something for you to look at...",
		date:global.clock.seconds,
		message:"Ah well. Another time perhaps. God speed, Commander."}
	);

	// set the process to the end point
	this._processState = 10;

}

this.$TooLate = function() {

	// connect to the email system,
	var w = worldScripts.EmailSystem;

	// send a new email
	w.$createEmail({sender:"The Chaser",
		subject:"RE: Something for you to look at...",
		date:global.clock.seconds,
		message:"I'm sorry commander, the opportunity to participate has passed.\n\nRemeber to check your inbox!"}
	);

	// set the process to the end point
	this._processState = 10;

}

this.$Result = function(choice) {

	// connect to the email system,
	var w = worldScripts.EmailSystem;

	switch (choice) {
		case "good":
			// send a new email
			w.$createEmail({sender:"The Chaser",
				subject:"RE: Congratulations!",
				date:global.clock.seconds,
				message:"That's great. I'm so glad you enjoyed it. Have a great day.\n\nRight on, Commander!"}
			);
			break;
		case "bad":
			// send a new email
			w.$createEmail({sender:"The Chaser",
				subject:"RE: Congratulations!",
				date:global.clock.seconds,
				message:"Ah well. You can't please everyone.\n\nHave a great day, Commander!"}
			);
			break;
	}
	// set the process to the end point
	this._processState = 10;

}
