"use strict";
this.name        = "CommsLogMFD_Equipment";
this.author      = "phkb";
this.copyright   = "2016 phkb";
this.description = "Allows the communications log multi-function display to be scrolled and cleared.";
this.licence     = "CC BY-NC-SA 4.0";

//-------------------------------------------------------------------------------------------------------------
this.activated = function () {
	var w = worldScripts.CommsLogMFD;
	if (w._currMode == null) {
		w._currMode = 0;
	}
	w._nextMode = -1;
	var bResetTimer = false;
	var p = player;
	switch(w._currMode) {
		case 0:
			// scroll further into history (increase the amount of scroll)
			w._scrollLaunch = 0;
			if (w._commsMFD_scroll < w._commsMFD_maxscroll) {
				w._commsMFD_scroll += 1;
				w.$commsMFD_updateview();
				bResetTimer = true;
			}
			break;
		case 1:
			// scroll back towards current (reduce the amount of scroll)
			w._scrollLaunch = 0;
			if (w._commsMFD_scroll > 0) {
				w._commsMFD_scroll -= 1;
				// set the next mode to be mode 0, so we can quickly go back and forwards between messages
				this._nextMode = 0;
				w.$commsMFD_updateview();
				if (w._commsMFD_scroll != 0) {
					bResetTimer = true;
				}
			}
			break;
		case 2:
			// scroll back to previous launch
			w._scrollLaunch = 1;
			w.$commsMFD_updateview();
			bResetTimer = true;
			break;
		case 3:
			// scroll to next launch
			w._scrollLaunch = -1;
			// set the next mode to be mode 2, so we can quickly go back and forwards between launches
			w._nextMode = 2;
			w.$commsMFD_updateview();
			bResetTimer = true;
			break;
		case 4:
			// view current
			w._commsMFD_scroll = 0;
			w._scrollLaunch = 0;
			w.$commsMFD_updateview();
			w._currMode = 0;
			this.$stoptimer();
			p.consoleMessage("Scroll back mode autoselected");
			break;
		case 5:
			// view oldest
			w._scrollLaunch = 0;
			w._commsMFD_scroll = w._commsMFD_maxscroll;
			w.$commsMFD_updateview();
			w._currMode = 1;
			p.consoleMessage("Scroll forward mode autoselected");
			bResetTimer = true;
			break;
		case 6:
		    // clear log
			w._scrollLaunch = 0;
			w._commsMFD_log = "";
			w._commsMFD_lines = [];
			w._commsMFD_scroll = 0;
			w.$commsMFD_updateview();
			w._currMode = 0;
			this.$stoptimer();
			p.consoleMessage("Log cleared");
			break;
		case 7:
			// write comms to log
			w.$dumpLog();
			p.consoleMessage("Output of comms to log complete");
			w._currMode = 0;
			this.$stoptimer();
			p.consoleMessage("Scroll back mode autoselected");
			break;
		case 8:
			if (w._scrollMethod === 0) {
				p.consoleMessage("Scroll mode = By message");
				w._scrollMethod = 1;
			} else {
				p.consoleMessage("Scroll mode = By line");
				w._scrollMethod = 0;
			}
			w._currMode = 0;
			w._scrollLaunch = 0;
			w._commsMFD_scroll = 0;
			w.$commsMFD_updateview();
			this.$stoptimer();
			break;
	}
	if (bResetTimer === true) this.$resettimer();
	this.$playSound("activate");
}

//-------------------------------------------------------------------------------------------------------------
this.$stoptimer = function() {
	if (this._timeout && this._timeout.isRunning) this._timeout.stop();
}

//-------------------------------------------------------------------------------------------------------------
this.mode = function () {
	var w = worldScripts.CommsLogMFD;
	// change the mode
	// if the nextMode value has been set, make this the next mode
	if (w._nextMode != null && w._nextMode != -1) {
		w._currMode = w._nextMode;
		w._nextMode = -1;
	} else {
		// if the value hasn't been set yet, start at default mode (0)
		if (w._currMode == null) {
			w._currMode = 0;
		} else {
			// otherwise, increment the mode
			w._currMode += 1;
			// once we get to 9, switch back to 0
			if (w._currMode === 9) {
				w._currMode = 0;
			}
		}
	}

	var p = player;

	// display a console message about which mode we're in now
	switch(w._currMode) {
		case 0:
			p.consoleMessage("Scroll back mode");
			break;
		case 1:
			p.consoleMessage("Scroll forward mode");
			break;
		case 2:
			p.consoleMessage("Scroll to previous launch");
			break;
		case 3:
			p.consoleMessage("Scroll to next launch");
			break;
		case 4:
			p.consoleMessage("View current");
			break;
		case 5:
			p.consoleMessage("View oldest");
			break;
		case 6:
			p.consoleMessage("Clear log mode");
			break;
		case 7:
			p.consoleMessage("Write comms to lastest log");
			break;
		case 8:
			if (worldScripts.CommsLogMFD._scrollMethod === 0) {
				p.consoleMessage("Switch to message scrolling");
			} else {
				p.consoleMessage("Switch to line scrolling");
			}
	}
	this.$playSound("mode");
}

//-------------------------------------------------------------------------------------------------------------
this.$resettimer = function() {
	this.$stoptimer();
	this._timeout = new Timer(this, this.$timerdone, worldScripts.CommsLogMFD._scrollTimeout, 0);
}

//-------------------------------------------------------------------------------------------------------------
this.$timerdone = function $timerdone() {
	var w = worldScripts.CommsLogMFD;
	w._currMode = 0;
	w._commsMFD_scroll = 0;
	w._scrollLaunch = 0;
	w.$commsMFD_updateview();
}

//-------------------------------------------------------------------------------------------------------------
// play sound effects
this.$playSound = function(soundtype) {
	var mySound = new SoundSource;

	switch (soundtype) {
		case "mode":
			mySound.sound = "[@click]";
			break;
		case "activate":
			mySound.sound = "[@beep]";
			break;
			
	}
	mySound.loop = false;
	mySound.play();
}
