"use strict";
this.name = "GalCopBB_EjectionDamper";
this.author = "phkb";
this.copyright = "2018 phkb";
this.description = "Equipment to cause ejected cargo to slow down to a stop, rather than to float away at a constant speed.";
this.license = "CC BY-NC-SA 4.0";

this._cargoList = [];
this._resetTimer = null;
this._usesLeft = 0;
this._unitOn = false;

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
    if (missionVariables.GalCopBBMissions_EjectionDamper) this._usesLeft = parseInt(missionVariables.GalCopBBMissions_EjectionDamper);
    if (player.ship.equipmentStatus("EQ_GCM_Ejection_REMOVE") === "EQUIPMENT_OK") player.ship.removeEquipment("EQ_GCM_Ejection_REMOVE");
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function () {
    missionVariables.GalCopBBMissions_EjectionDamper = this._usesLeft;
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillDockWithStation = function (station) {
    this._unitOn = false;
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function (whom, why) {
    if (this._resetTimer && this._resetTimer.isRunning) this._resetTimer.stop();
}

//-------------------------------------------------------------------------------------------------------------
this.playerBoughtEquipment = function (equipmentKey) {
    if (equipmentKey === "EQ_GCM_EJECTION_DAMPER") {
        var eq = EquipmentInfo.infoForKey(equipmentKey);
        this._usesLeft = eq.scriptInfo.max_uses;
    }
    if (equipmentKey === "EQ_GCM_EJECTION_DAMPER_REMOVE") {
        player.ship.removeEquipment(equipmentKey);
        player.ship.removeEquipment("EQ_GCM_EJECTION_DAMPER");
    }
}

//-------------------------------------------------------------------------------------------------------------
this.mode = this.activated = function () {
    var ws = worldScripts.GalCopBB_EjectionDamper;
    ws._unitOn = !ws._unitOn;
    switch (ws._unitOn) {
        case true:
            player.consoleMessage(expandDescription("[gcm_damper_on]", { remaining: ws._usesLeft }), 3);
            this.$playSound("on");
            break;
        case false:
            player.consoleMessage(expandDescription("[gcm_damper_off]"), 3);
            this.$playSound("off");
            break;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipDumpedCargo = function (cargo) {
    if (this._unitOn === true) {
        this._usesLeft -= 1;
        player.consoleMessage(expandDescription("[gcm_damper_applied]", { remaining: this._usesLeft }), 2);
        cargo.desiredSpeed = 0;
        this._cargoList.push(cargo);
        if (this._resetTimer == null || this._resetTimer.isRunning === false) {
            this._resetTimer = new Timer(this, this.$resetCargo, 2, 2);
        }
        if (this._usesLeft <= 0) {
            this._usesLeft = 0;
            this._unitOn = false;
            this.$playSound("off");
            player.ship.removeEquipment("EQ_GCM_EJECTION_DAMPER");
            player.consoleMessage(expandDescription("[gcm_damper_expended]"), 5);
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$resetCargo = function $resetCargo() {
    if (this._cargoList.length === 0) {
        this._resetTimer.stop();
        this._resetTimer = null;
        return;
    }
    for (var i = this._cargoList.length - 1; i >= 0; i--) {
        var cargo = this._cargoList[i];
        if (!cargo.velocity || cargo.velocity.magnitude() <= 5) {
            if (cargo.isValid && cargo.isInSpace) {
                cargo.performStop();
            }
            this._cargoList.splice(i, 1);
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
// play the buy/sell sound effects
this.$playSound = function $playSound(soundtype) {
    var mySound = new SoundSource;
    switch (soundtype) {
        case "on":
            mySound.sound = "[@switch-on]";
            break;
        case "off":
            mySound.sound = "[@switch-off]";
            break;
    }
    mySound.loop = false;
    mySound.play();
}