/*

gcm-guardAI.js

Priority-based AI for GalCop Mission guards, adjusted from the core Assassins and Escort AIs.

Oolite
Copyright © 2004-2013 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/

"use strict";

this.name = "GCM Guard AI";

//-------------------------------------------------------------------------------------------------------------
this.aiStarted = function() {
	var ai = new worldScripts["oolite-libPriorityAI"].PriorityAIController(this.ship);

	ai.setParameter("oolite_personalityMatchesLeader",0.9);
	ai.setCommunicationsRole("gcm-assassin");

	ai.setParameter("oolite_flag_witchspacePursuit",true);
	ai.setParameter("oolite_flag_surrendersLate",true);

    // add our custom AI so we can use all the AI properties via "this"
    ai.conditionScannerContainsDefenceTarget = this.$conditionScannerContainsDefenceTarget;
    ai.conditionDefenceShipUnderAttack = this.$conditionDefenceShipUnderAttack;
    ai.configurationAcquireDefenceShipTarget = this.$configurationAcquireDefenceShipTarget;

	ai.setPriorities([
		/* Fight */
		{
			condition: ai.conditionLosingCombat,
			behaviour: ai.behaviourFleeCombat,
			reconsider: 5
		},
		{
			condition: ai.conditionInCombat,
			configuration: ai.configurationAcquireCombatTarget,
			behaviour: ai.behaviourDestroyCurrentTarget,
			reconsider: 5
		},
		{
			condition: ai.conditionDefenceShipUnderAttack,
			truebranch: [
				{
					configuration: ai.configurationAcquireDefenceShipTarget,
					behaviour: ai.behaviourRepelCurrentTarget,
					reconsider: 5
				}
            ],
            reconsider: 2
		},
		/* Check for target entity and follow*/
		{
			preconfiguration: ai.configurationCheckScanner,
			condition: ai.conditionScannerContainsDefenceTarget,
			truebranch: [
				{
                    configuration: ai.configurationAcquireScannedTarget,
                    behaviour: ai.behaviourFollowCurrentTarget,
                    reconsider: 15
                }
            ],
            reconsider: 10
		},
		{
			condition: ai.conditionHasRememberedTarget,
			behaviour: ai.behaviourFollowCurrentTarget,
			reconsider: 15
		},
		{
			configuration: ai.configurationSetDestinationToWitchpoint,
			behaviour: ai.behaviourApproachDestination,
			reconsider: 30
		}
	]);
}

//-------------------------------------------------------------------------------------------------------------
this.$conditionScannerContainsDefenceTarget = function() {
    var scan = this.getParameter("oolite_scanResults");
    var tgt = this.getParameter("oolite_defendTarget");
    if (!tgt || tgt.isValid === false) return false;
	for (var i = scan.length-1 ; i >= 0 ; i--) {
        if (scan[i] == tgt) {
            this.setParameter("oolite_scanResultSpecific",tgt);
            return true;
        }
	}
	return false;
}

//-------------------------------------------------------------------------------------------------------------
this.$conditionDefenceShipUnderAttack = function() {
    var tgt = this.getParameter("oolite_defendTarget");
    if (!tgt || !tgt.script) return false;
    var attacker = tgt.script._attacker;
    if (this.distance(tgt) > this.scannerRange) {
        return false; // can't tell
    }
    if (attacker) {
        return true;
    }
	// no defence ship
	return false;
}

//-------------------------------------------------------------------------------------------------------------
this.$configurationAcquireDefenceShipTarget = function() {
    var tgt = this.getParameter("oolite_defendTarget");
    if (!tgt) return; // invalid?
    this.ship.target = tgt.script._attacker;
}