/*
========================================================================
ferdelance3G_trader.js
This file is part of the 'Ferdelance 3G' expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/


/*
====================
JSLINT: set options
====================
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "ferdelance3G_trader";
this.author = "UK_Eliter";
this.copyright = "";
this.description = "ferdelance3G_hunter.js (for NPCs)";
this.license = "CC-by-nc-sa 3.0";


/*
------------------
DEBUGGING SWITCHES
------------------
*/

// this.logging = true;

this.debug = false;

if (this.debug) {
	this.ship.reportAIMessages = true;
}


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	-------------------------
	EVENT HANDLERS
	(except incoming missile)
	-------------------------
	*/

	this.shipSpawned = function() // For ALLOCATING MISSILES
	{
		var capacity;
		var chanceForSeriousBomb = 0.1;
		var giveSeriousOrdinance = false;
		var i;
		var ordinanceAvailable;
		var ordinanceCount;
		var startTime;

		//Build list of available ordinance.
		ordinanceAvailable = ["EQ_MISSILE", "EQ_MISSILE", "EQ_MISSILE", "EQ_HARDENED_MISSILE", "EQ_HARDENED_MISSILE"];
		if (this.ship.hasRole("ferdelance3G_+T")) {
			giveSeriousOrdinance = true;
			chanceForSeriousBomb = 0.17;
		} else if (Math.random() > 0.8) {
			giveSeriousOrdinance = true;
		}
		if (giveSeriousOrdinance) {
			if (worldScripts["Missiles & Bombs"]) {
				ordinanceAvailable.push("EQ_RMB_FRAG_MISSILE", "EQ_RMB_OVERRIDE_MISSILE", "EQ_RMB_LAW_MISSILE", "EQ_RMB_INTERCEPT_MISSILE", "EQ_RMB_INTERCEPT_MISSILE", "EQ_RMB_INTERCEPT_MISSILE");
			}
			if (EquipmentInfo.infoForKey("EQ_TORPEDO_MISSILE")) {
				ordinanceAvailable.push("EQ_TORPEDO_MISSILE");
			}
			if (EquipmentInfo.infoForKey("EQ_HARPOON_NUKE1_MISSILE")) {
				ordinanceAvailable.push("EQ_HARPOON_NUKE1_MISSILE");
			}
			if (worldScripts["armoury_trackerWorldScript.js"]) {
				ordinanceAvailable.push("EQ_ARMOURY_STUNBOMB_MINE");
				if (this.ship.equipmentStatus("EQ_CLOAKING_DEVICE") != "EQUIPMENT_OK") {
					ordinanceAvailable.push("EQ_KDRONE_LAUNCHER_MINE", "EQ_CDRONE_LAUNCHER_MINE");
				}
			}
			if (EquipmentInfo.infoForKey("EQ_NEXUS_BUG_MISSILE")) {
				ordinanceAvailable.push("EQ_NEXUS_PREMIUM_MISSILE");
				if (Math.random() > 0.2) {
					ordinanceAvailable.push("EQ_NEXUS_BASIC_MISSILE");
				} else {
					ordinanceAvailable.push("EQ_NEXUS_PREMIUM_MISSILE");
				}
			}
			capacity = this.ship.missileCapacity;
			if (Math.random() <= chanceForSeriousBomb) {
				this.ship.awardEquipment("EQ_QC_MINE"); // NB: actually award
				--capacity;
			}
		}
		// Load ordinance to ship
		ordinanceCount = ordinanceAvailable.length;
		i = capacity - 1;
		do {
			this.ship.awardEquipment(ordinanceAvailable[~~(Math.random() * ordinanceCount)]);
		}
		while (i--);
		delete this.shipSpawned;
	};


	/*
	----------------------
	JSLINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF