/*
========================================================================
ferdelance3G_populator.js
This file is part of the 'Ferdelance 3G' expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/


/*
====================
JSLINT: set options
====================
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "ferdelance3G_populator";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 4";
this.description = "Fer-de-Lance 3G populator script";


/*
------------------
DEBUGGING SWITCHES
------------------
*/

// this.logging = true;
this.consoleDebugMessages = false; // to disable this, set it to false. DO NOT comment it out.


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	-----------------------
	INTERSTELLAR population
	-----------------------
	*/

	this.interstellarSpaceWillPopulate = function() {
		if (Math.random() < 0.94) {
			return;
		} // NB: 0.94
		// Otherwise
		system.setPopulator("ferdelance3G_interstellar", {
			priority: 300,
			callback: this._addinterstellar3Gs.bind(this)
		});
	};

	this._addinterstellar3Gs = function(pos) {
		var threeG_number = ~~(1 + (Math.random() * 8));
		this.$addShips_ringless("ferdelance3G_interstellar", threeG_number, [0, 0, 0], 22000);
	};

	this.$isBug = function(e) {
		return e.isThargoid;
	};

	this.interstellarSpaceWillRepopulate = function() {
		// It is important for smooth gameplay that this function runs very quickly. If calculations are needed, run as many as possible in the populator function to save the result.
		// 'interstellarSpaceWillRepopulate' does *not* use system.setPopulator 
		//
		// Note re Interstellar Tweaks OXP: that function will stop this routine being called, except in 'modified' scenarios. For 'new' scenarios, InterstellarTweaks can itself spawn 3Gs.

		if (!player.ship || !player.ship.position) {
			return;
		}

		if (this.threeG_addNoMore === true) {
			return;
		}

		var bugs = system.filteredEntities(this, this.$isBug);
		if (bugs.length < 5) {
			return;
		}

		var police_num = system.countShipsWithRole("police");
		if (police_num >= bugs.length) {
			return;
		}

		var threeG_chanceAdd;
		if (police_num < 15) {
			threeG_chanceAdd = 0.02;
		} else {
			threeG_chanceAdd = 0.05;
		}
		var numCarriers = system.countShipsWithRole("thargoid_carrier");
		if (numCarriers > 2) {
			threeG_chanceAdd = threeG_chanceAdd * (numCarriers - 1);
			// "threeG_chanceAdd* = (numCarriers-1)" throws exception
		}
		if (threeG_chanceAdd > 0.4) {
			threeG_chanceAdd = 0.4;
		}
		if (Math.random() > threeG_chanceAdd) {
			return;
		}

		// Else
		var threeG_number = 3 + ~~((Math.random() * 6) + 1);
		system.addGroup("ferdelance3G_interstellar", threeG_number, [0, 0, 0], 875);
		if (Math.random() < 0.6) {
			this.threeG_addNoMore = true;
		}
	};


	/*
	------------------
	STELLAR population
	------------------
	*/

	this.systemWillPopulate = function() {
		/* STELLAR POPULATOR
		LANE_PS, LANE_WP, LANE_WS, STATION_AEGIS, PLANET_ORBIT, OUTER_SYSTEM, OUTER_SYSTEM_OFFPLANE
		Use 'callback: this._myFunction.bind(this)' not callback: this._myFunction' in order to use global variables and functions
		*/

		// log("3G - DEBUG", "entered populator"); // TEST

		if (!((system.government < 3) && (Math.random() < 0.2))) {
			return;
		}

		var place = ~~(1 + (Math.random() * 8));

		// log("3G - DEBUG", "place is <" + place + ">"); // TEST

		switch (place) {
			case 1:
				system.setPopulator("ferDeLance3G-huntersPO", {
					groupCount: 1,
					priority: 150,
					location: "PLANET_ORBIT",
					callback: this._addHunter.bind(this)
				});
				break;
			case 2:
				system.setPopulator("ferDeLance3G-huntersLWP", {
					groupCount: 1,
					priority: 111,
					location: "LANE_WP",
					callback: this._addHunter.bind(this)
				});
				break;
			case 3:
				system.setPopulator("ferDeLance3G-huntersOS", {
					groupCount: 1,
					priority: 150,
					location: "OUTER_SYSTEM",
					callback: this._addHunter.bind(this)
				});
				break;
			case 4:
				system.setPopulator("ferDeLance3G-huntersSA", {
					groupCount: 1,
					priority: 150,
					location: "STATION_AEGIS",
					callback: this._addHunter.bind(this)
				});
				break;
			case 5:
				system.setPopulator("ferDeLance3G-huntersWP", {
					groupCount: 1,
					priority: 110,
					location: "WITCHPOINT",
					callback: this._addHunter.bind(this)
				});
				break;
			case 6:
				system.setPopulator("ferDeLance3G-huntersSOL", {
					groupCount: 1,
					priority: 150,
					location: "STAR_ORBIT_LOW",
					callback: this._addHunter.bind(this)
				});
				break;
			default:
				system.setPopulator("ferDeLance3G-huntersLWPS", {
					groupCount: 1,
					priority: 111,
					location: "LANE_WPS",
					callback: this._addHunter.bind(this)
				});
		}
	};

	this._addHunter = function(pos) {
		var s = system.addShips("ferdelance3G_hunter", 1, pos, 35000);
		// function addShips(role : String, count : Number [, position: vectorExpression] [, radius: Number]) : Array
		// log("3G TESTING", "Added stellar hunter");
	};


	/*
	-----
	OTHER
	-----
	*/

	this.playerWillEnterWitchspace = function() {
		this.threeG_addNoMore = false;
	};

	this.$addShips_ringless = function(role, count, position, radius) {
		var i, offset, ships;
		offset = new Vector3D(0, 50000, 0);
		if (count < 1) {
			this.$error("Bad count argument <" + count + "> for function addShips_ringless");
			count = 1; // fix the problem.
		}
		ships = system.addShips(role, count, offset, radius);
		offset = new Vector3D(position).subtract(offset);
		i = ships.length;
		while (i--) {
			ships[i].position = ships[i].position.add(offset);
		}
		return ships;
	};

	// For TESTING
	/*
	this.shipWillLaunchFromStation = function()
	{
		// this.$addShips_ringless("ferdelance3G_trader", 4, player.ship.position, 25000);
		// this.$addShips_ringless("ferdelance3G_pirate", 4, player.ship.position, 25000);
		this.$addShips_ringless("ferdelance3G_pirateKing", 2, player.ship.position, 25000);
		// this.$addShips_ringless("ferdelance3G_hunter", 4, player.ship.position, 25000);
		// this.$addShips_ringless("ferdelance3G_police", 3, player.ship.position, 25000);
		//this.$addShips_ringless("ferdelance3G_interstellar", 4, player.ship.position, 25000);
		this.$addShips_ringless("ferdelance3G_hardPiratePoliceDecomissioned", 1, player.ship.position, 25000);
		this.$addShips_ringless("ferdelance3G_hardestHunterPoliceDecomissioned", 1, player.ship.position, 25000);
	}
	*/


	/*
	----------------------
	JSLINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF