/*
========================================================================
ferdelance3G_pirate.js
This file is part of the 'Ferdelance 3G' expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/


/*
====================
JSLINT: set options
====================
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "ferdelance3G_pirate";
this.author = "UK_Eliter";
this.copyright = "";
this.description = "ferdelance3G_pirate.js (for NPCs)";
this.license = "CC-by-nc-sa 3.0";

/*
------------------
DEBUGGING SWITCHES
------------------
*/


// this.logging = true;

this.debug = false;

if (this.debug) {
	this.ship.reportAIMessages = true;
}


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	---------------
	*/

	this.shipSpawned = function() // For BOUNTY and ALLOCATING MISSILES
	{
		var l;
		/*jshint -W009 */
		var ordinance_available = new Array();
		/*jshint +W009 */
		var ordinance_available_level_two;
		var ordinance_available_level_three_chance;
		var ordinance_capacity;
		var ordinanceCount;
		var ordinance_available_length;

		ordinance_available_level_two = false;
		ordinance_available_level_three_chance = 0.11;
		ordinance_capacity = this.shipSpawned.missileCapacity;

		if (this.ship.hasRole("ferdelance3G_+T")) {
			ordinance_available_level_two = true;
			if (this.ship.hasRole("ferdelance3G_pirateKing")) {
				this.ship.bounty += 50 + ~~((Math.random() * 120) + 1);
				ordinance_available_level_three_chance = 0.8;
			}
		} else if (Math.random() > 0.6) {
			ordinance_available_level_two = true;
		}

		if (ordinance_available_level_two) {
			if (worldScripts["Missiles & Bombs"]) {
				ordinance_available.push("EQ_RMB_FRAG_MISSILE", "EQ_RMB_OVERRIDE_MISSILE", "EQ_RMB_INTERCEPT_MISSILE", "EQ_RMB_INTERCEPT_MISSILE");
			}

			if (worldScripts["armoury_trackerWorldScript.js"]) {
				ordinance_available.push("EQ_ARMOURY_STUNBOMB_MINE");
				if (this.ship.equipmentStatus("EQ_CLOAKING_DEVICE") != "EQUIPMENT_OK") {
					ordinance_available.push("EQ_KDRONE_LAUNCHER_MINE", "EQ_CDRONE_LAUNCHER_MINE");
				}
			}

			if (EquipmentInfo.infoForKey("EQ_TORPEDO_MISSILE")) {
				ordinance_available.push("EQ_TORPEDO_MISSILE");
			}

			if (EquipmentInfo.infoForKey("EQ_HARPOON_NUKE1_MISSILE")) {
				ordinance_available.push("EQ_HARPOON_NUKE1_MISSILE");
			}

			if (EquipmentInfo.infoForKey("EQ_NEXUS_BUG_MISSILE")) {
				if (Math.random() > 0.25) {
					ordinance_available.push("EQ_NEXUS_BASIC_MISSILE");
				} else {
					ordinance_available.push("EQ_NEXUS_PREMIUM_MISSILE");
				}
			}

			if (Math.random() < ordinance_available_level_three_chance) {
				this.ship.awardEquipment("EQ_QC_MINE"); // NB: actually award
				--ordinance_capacity;
			}
		}

		// Ensure there is at least one item in the ordinance list (so that can triple the list and not get zero).
		ordinance_available.push("EQ_HARDENED_MISSILE");

		// Triple the size of ordinance_available by adding, for every entry present already, a normal missile and a hardhead. 
		ordinance_available_length = ordinance_available.length;
		l = ordinance_available_length;
		while (l--) {
			ordinance_available.push("EQ_MISSILE");
			ordinance_available.push("EQ_HARDENED_MISSILE");
		}

		// Load the ordinance (save for Q-Mine, which may have been loaded above).
		ordinance_available_length = ordinance_available.length; // The latter has changed, so set the former again.
		l = ordinance_capacity;
		do {
			this.ship.awardEquipment(ordinance_available[~~(Math.random() * ordinance_available_length)]);
		}
		while (l--);
		delete this.shipSpawned;
	};


	/*
	=======================
	JSHINT: end of wrapper
	=======================
	*/

}).call(this);

// EOF