/*
========================================================================
ferdelance3G_milInterstellar.js
This file is part of the 'Ferdelance 3G' expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/


/*
====================
JSLINT: set options
====================
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "ferdelance3G_milInterstellar.js";
this.author = "UK_Eliter";
this.copyright = "";
this.description = "ferdelance3G-mainScript.js (for NPCs)";
this.license = "CC-by-nc-sa 3.0";


/*
------------------
DEBUGGING SWITCHES
------------------
*/

this.debug = false;

if (this.debug) {
	this.ship.reportAIMessages = true;
}


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	this.shipSpawned = function() {
		// Record presence/absence of some OXPs or weapons for multiple use within THIS function.

		var OXPInstalled_extraBugs;
		if (worldScripts["extraThargoids_populator.js"]) {
			OXPInstalled_extraBugs = true;
		} else {
			OXPInstalled_extraBugs = false;
		}

		var OXPInstalled_missilesAndBombs;
		if (worldScripts["Missiles & Bombs"]) {
			OXPInstalled_missilesAndBombs = true;
		} else {
			OXPInstalled_missilesAndBombs = false;
		}

		var OXPInstalled_nexus;
		if (!EquipmentInfo.infoForKey("EQ_NEXUS_BUG_MISSILE")) {
			OXPInstalled_nexus = true;
		} else {
			OXPInstalled_nexus = false;
		}

		// Create weighted list of available ordinance - varying with ship type
		var ordinanceAvailable;
		if (this.ship.hasRole("ferdelance3Bugblatter")) {
			// BUGBLATTER
			ordinanceAvailable = ["EQ_F3G_ANTISWEEP_MISSILE", "EQ_F3G_ANTISWEEP_MISSILE", "EQ_HARDENED_MISSILE"];
			if (OXPInstalled_nexus === true) {
				ordinanceAvailable.push("EQ_NEXUS_BUG_MISSILE", "EQ_NEXUS_BUG_MISSILE");
			} else if (OXPInstalled_missilesAndBombs) {
				ordinanceAvailable.push("EQ_RMB_THARGOID_MISSILE", "EQ_RMB_THARGOID_MISSILE");
			}
			if (worldScripts["armoury_trackerWorldScript.js"]) {
				ordinanceAvailable.push("EQ_ARMOURY_SCREAMER_MINE");
			}
			if ((worldScripts.TCAT_masterScript != undefined)) {
				ordinanceAvailable.push("EQ_TCAT_JAMMER_MINE");
			}
			if (EquipmentInfo.infoForKey("EQ_TORPEDO_MISSILE")) {
				ordinanceAvailable.push("EQ_TORPEDO_MISSILE");
			}
		} else {
			// NORMAL
			ordinanceAvailable = ["EQ_F3G_ANTISWEEP_MISSILE", "EQ_F3G_ANTISWEEP_MISSILE", "EQ_HARDENED_MISSILE", "EQ_HARDENED_MISSILE"];
			if (OXPInstalled_extraBugs) {
				ordinanceAvailable.push("EQ_F3G_ANTISWEEP_MISSILE");
			}
			if (OXPInstalled_nexus === true) {
				ordinanceAvailable.push("EQ_NEXUS_BUG_MISSILE", "EQ_NEXUS_BUG_MISSILE");
				if (OXPInstalled_missilesAndBombs) {
					ordinanceAvailable.push("EQ_RMB_THARGOID_MISSILE");
				}
			} else if (OXPInstalled_missilesAndBombs) {
				ordinanceAvailable.push("EQ_RMB_THARGOID_MISSILE", "EQ_RMB_THARGOID_MISSILE");
			} else if (EquipmentInfo.infoForKey("EQ_MILITARY_MISSILE")) {
				ordinanceAvailable.push("EQ_MILITARY_MISSILE", "EQ_MILITARY_MISSILE", "EQ_MILITARY_MISSILE");
			}
		}
		var ordinance_shipSlots = this.ship.missileordinance_shipSlots;
		var ordinance_availableArray_length = ordinanceAvailable.length;
		var i = ordinance_shipSlots - 1;
		do {
			this.ship.awardEquipment(ordinanceAvailable[~~(Math.random() * ordinance_availableArray_length)]);
		}
		while (i--);
		//
		delete this.shipSpawned;
	};


	/*
	--------
	SCANNING
	--------
	*/

	this.$isSweeper = function(e) {
		return e.isShip && e.isThargoid && e.hasRole("extraThargoids_sweeper");
	};

	this.$isBigBug = function(e) {
		return e.isShip && e.isThargoid && e.mass > 900000;
	};

	this.$isVeryBigBug = function(e) {
		return e.isShip && e.isThargoid && e.mass > 4600000;
	};

	this.$scanForPrimaryTarget = function() {
		if (!this.ship || !this.ship.isPiloted) {
			return;
		}
		// if ( this.debug ) {player.consoleMessage("3G - SEEKING", 5);}
		// Look for sweepers
		var bigBugs;
		var sweepers = system.filteredEntities(this, this.$isSweeper, this.ship, 25600);
		if (sweepers.length > 0) {
			// See whether target a sweeper or instead look for a big bug
			bigBugs = system.filteredEntities(this, this.$isVeryBigBug, this.ship, 75000); // note range
			if (bigBugs.length === 0) {
				// Is at least one sweeper, are no (very) big bugs - so, go for a sweeper.
				// So -if is more than one sweeper, decide which one to target.
				if (sweepers.length === 1 || Math.random() < 0.65) {
					this.ship.target = sweepers[0];
				} else {
					this.ship.target = sweepers[1];
				}
				this.ship.reactToAIMessage("TARGET_FOUND");
			} else {
				// Is at least one sweeper and at least one (very) big bug. So decide which type to go for.
				var r = Math.random();
				if (r < 0.85) {
					// Target a sweeper.
					if (sweepers.length === 1 || r < 0.6) {
						this.ship.target = sweepers[0];
					} else {
						this.ship.target = sweepers[1];
					}
					this.ship.reactToAIMessage("TARGET_FOUND");
				} else {
					// Target a (very) bigbug.
					// Now decide which bigbug, if more than one.
					if (bigBugs.length === 1 || Math.random() < 0.6) {
						this.ship.target = bigBugs[0];
					} else {
						this.ship.target = bigBugs[1];
					}
					this.ship.reactToAIMessage("TARGET_FOUND");
				}
			}
		} else {
			// Are no sweepers. So look for (very) big bugs.
			bigBugs = system.filteredEntities(this, $isVeryBigBug, this.ship, 25600); // note range
			if (bigBugs.length > 0) {
				if (bigBugs.length === 1 || Math.random() < 0.55) {
					this.ship.target = bigBugs[0];
				} else {
					this.ship.target = bigBugs[1];
				}
				this.ship.reactToAIMessage("TARGET_FOUND");
			} else {
				// Found no sweeper nor any very big bug - so look, up to just outside scanner range, for fairly big bugs.
				bigBugs = system.filteredEntities(this, this.$isBigBug, this.ship, 25600);
				if (bigBugs.length > 0) {
					if (bigBugs.length === 1 || Math.random() < 0.6) {
						this.ship.target = bigBugs[0];
					} else {
						this.ship.target = bigBugs[1];
					}
					this.ship.reactToAIMessage("TARGET_FOUND");
				} else {
					this.ship.reactToAIMessage("NOTHING_FOUND"); // Do need always to end with this or $doInterceptOfThargoid.
				}
			}
		}
	};

	this.$isSuitableTarget = function(e) {
		return e.isShip && e.isThargoid && e.mass > 500000 && e.primaryRole !== "thargoidRebel";
	};

	this.$scanForSecondaryTarget = function() {
		if (!this.ship || !this.ship.isPiloted) {
			return;
		}
		// if ( this.debug ) {player.consoleMessage("3G - SEEKING", 5);}

		// Tharglet mass: 7829.43
		// Frigate mass: 110048
		// Warship mass: 899378
		var targetArray = system.filteredEntities(this, this.$isSuitableTarget, this.ship, 25600);
		if (targetArray.length === 0) {
			this.ship.reactToAIMessage("NOTHING_FOUND");
			return;
		}
		// else
		if ((targetArray.length === 1) || (Math.random() < 0.7)) {
			this.ship.target = targetArray[0];
		} else {
			this.ship.target = targetArray[1];
		}
		// player.consoleMessage("3G - OK!", 5);
		this.ship.reactToAIMessage("TARGET_FOUND");
	};

	this.$isSuitableNavy = function(e) {
		return e.isShip && (e.mass > 20000000) && (e.isPolice || e.scanClass === "CLASS_MILITARY");
	};

	this.$findNavy = function() {
		var navalArray;

		navalArray = system.filteredEntities(this, this.$isSuitableNavy, this.ship, 50000);
		if (navalArray.length > 0) {
			if ((navalArray.length === 1) || (Math.random() < 0.7)) {
				this.ship.target = navalArray[0];
			} else {
				this.ship.target = navalArray[1];
			}
			this.ship.reactToAIMessage("TARGET_FOUND");
		} else {
			this.ship.reactToAIMessage("NOTHING_FOUND");
		}
	};


	/*
	---------------------
	ATTACK ROUTINES & co.
	---------------------
	*/

	this.$considerRespondingToAttack = function() {
		if (!this.ship || !this.ship.isPiloted) {
			return;
		}
		if (!this.ship.target || !this.ship.target.isValid) {
			return;
		}
		if (this.ship.target.isThargoid) {
			this.ship.reactToAIMessage("RESPOND_TO_ATTACK");
			return;
		}
		// else
		if (this.ship.target.scanClass === "CLASS_MILITARY" || this.ship.target.scanClass === "CLASS_POLICE") {
			if (Math.random() < 0.02) {
				this.ship.reactToAIMessage("RESPOND_TO_ATTACK");
			} else {
				this.ship.reactToAIMessage("POOTLE_IN_RESPONSE_TO_ATTACK");
			}
		} else {
			if (Math.random() < 0.2) {
				this.ship.reactToAIMessage("RESPOND_TO_ATTACK");
			} else {
				this.ship.reactToAIMessage("POOTLE_IN_RESPONSE_TO_ATTACK");
			}
		}
	};

	this.$considerRespondingToAttackWhenInterceptingNavy = function() {
		if (!this.ship || !this.ship.isPiloted) {
			return;
		}
		if (!this.ship.target || !this.ship.target.isValid) {
			return;
		}
		if (
			this.ship.target.isPlayer ||
			(!this.ship.target.isThargoid && (this.ship.target.scanClass !== "CLASS_MILITARY") && (this.ship.target.scanClass !== "CLASS_POLICE"))
		) {
			if (Math.random() < 0.27) {
				this.ship.reactToAIMessage("RESPOND_TO_ATTACK");
			} else {
				this.ship.reactToAIMessage("DO_NOT_RESPOND_TO_ATTACK");
			}
		} else {
			this.ship.reactToAIMessage("RESPOND_TO_ATTACK");
		}
	};

	this.$setMisjump = function() {
		var r = Math.random();
		this.ship.scriptedMisjump = true;
		if (r < 0.4) {
			this.ship.scriptedMisjumpRange = r * 2;
		}
	};


	/*
	---------
	DEBUGGING
	---------
	*/

	//this.messagePlayerIfPlayerWithinScannerRangeOfShip = function(text)
	//{
	//	if (!this.ship) {return;}
	//	if (!this.ship.position) {return;}
	//	if (!player.ship) {return;}
	//	if (!player.ship.isValid) {return;}
	//	if ( this.ship.position.distanceTo(player.ship.position) < 23000 ) {player.consoleMessage(text, 6);}
	//}
	//
	//
	//this.message = function(text) {player.consoleMessage(text, 6);}


	/*
	----------------------
	JSLINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF