/*
========================================================================
ferdelance3G_hunter.js
This file is part of the 'Ferdelance 3G' expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/

/*
====================
JSLINT: set options
====================
*/

/*jshint esversion: 6*/
/*jshint sub:true*/

this.name = "ferdelance3G_hunter";
this.author = "UK_Eliter";
this.copyright = "";
this.description = "ferdelance3G_hunter.js (for NPCs)";
this.license = "2014 CC-by-nc-sa 3.0";


/*
------------------
DEBUGGING SWITCHES
------------------
*/

// this.logging = true;
var consoleDebugMessages = false; // do NOT comment this out. Rather, to disable, set to false.
this.debug = false;

if (this.debug) {
	this.ship.reportAIMessages = true;
}


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";

	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	this.shipSpawned = function() {
		var r = Math.random();
		if (r > 0.45) {
			// ** Special ORDINANCE **
			// 1st level ordinance: possibility of some hardheads; 2nd level: more serious stuff; 3rd: q-bomb..
			var capacity;
			var chanceThirdLevelOrdinance = 0.11;
			var giveSecondLevelOrdinance = false;
			var i;
			var ordinanceAvailable;
			var ordinanceCount;

			ordinanceAvailable = ["EQ_MISSILE", "EQ_MISSILE", "EQ_MISSILE"]; // Hard-heads added to the list, below
			if (this.ship.hasRole("ferdelance3G_+T")) {
				giveSecondLevelOrdinance = true;
				chanceThirdLevelOrdinance = 0.15;
			} else if (r > 0.7) {
				giveSecondLevelOrdinance = true;
			}
			if (giveSecondLevelOrdinance) {
				if (worldScripts["Missiles & Bombs"]) {
					ordinanceAvailable.push("EQ_RMB_FRAG_MISSILE", "EQ_RMB_OVERRIDE_MISSILE", "EQ_RMB_LAW_MISSILE", "EQ_RMB_INTERCEPT_MISSILE", "EQ_RMB_INTERCEPT_MISSILE", "EQ_RMB_INTERCEPT_MISSILE");
				}
				if (EquipmentInfo.infoForKey("EQ_TORPEDO_MISSILE")) {
					ordinanceAvailable.push("EQ_TORPEDO_MISSILE");
				}
				if (EquipmentInfo.infoForKey("EQ_HARPOON_NUKE1_MISSILE")) {
					ordinanceAvailable.push("EQ_HARPOON_NUKE1_MISSILE");
				}
				if (worldScripts["armoury_trackerWorldScript.js"]) {
					ordinanceAvailable.push("EQ_ARMOURY_STUNBOMB_MINE");
					if (this.ship.equipmentStatus("EQ_CLOAKING_DEVICE") != "EQUIPMENT_OK") {
						ordinanceAvailable.push("EQ_KDRONE_LAUNCHER_MINE", "EQ_CDRONE_LAUNCHER_MINE");
					}
				}
				if (EquipmentInfo.infoForKey("EQ_NEXUS_BUG_MISSILE")) {
					ordinanceAvailable.push("EQ_NEXUS_PREMIUM_MISSILE");
					if (r > 0.9) {
						ordinanceAvailable.push("EQ_NEXUS_PREMIUM_MISSILE");
					} else {
						ordinanceAvailable.push("EQ_NEXUS_BASIC_MISSILE");
					}
				}
				capacity = this.ship.missileCapacity;
				// LEVEL THREE
				if (Math.random() <= chanceThirdLevelOrdinance) {
					this.ship.awardEquipment("EQ_QC_MINE"); // NB: actually award
					--capacity;
				}
			}
			ordinanceCount = ordinanceAvailable.length;
			i = ordinanceCount;
			while (i--) {
				ordinanceAvailable.push("EQ_HARDENED_MISSILE");
			} // add one of these for every existing missile in the list
			// Load ordinance to ship
			ordinanceCount = ordinanceAvailable.length; // this will have changed
			i = capacity - 1;
			do {
				this.ship.awardEquipment(ordinanceAvailable[~~(Math.random() * ordinanceCount)]);
			}
			while (i--);
		}
		/*
		**	BOUNTY **
			NB: This script is used not only for hunters but also for assassins.
		*/
		var r2 = Math.random(); // Threshold is 0.7. *Does* need to be r*2*.
		if (r2 > 0.7) {
			if (r2 < 0.9) {
				this.ship.bounty += (Math.ceil(r * 32));
				// sic - 'r', not 'r2'.
			} else {
				this.ship.bounty += 2 + (Math.ceil(r * 120));
				// sic - 'r', not 'r2'.
			}
		}
		// **CLEAN-UP **
		delete this.shipSpawned;
	};



	/*
	----------------------
	JSLINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF